/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.graphic.SpecialText;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.ugraphic.AbstractCommonUGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UComment;
import znaishaded.net.sourceforge.plantuml.ugraphic.UDriver;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEmpty;
import znaishaded.net.sourceforge.plantuml.ugraphic.UParam;
import znaishaded.net.sourceforge.plantuml.ugraphic.UShape;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public abstract class AbstractUGraphic<O>
extends AbstractCommonUGraphic {
    private final O graphic;
    private final Map<Class<? extends UShape>, UDriver<?, O>> drivers = new HashMap();
    private static final UDriver<?, ?> NOOP_DRIVER = new UDriver<UShape, Object>(){

        @Override
        public void draw(UShape shape, double x, double y, ColorMapper mapper, UParam param, Object object) {
        }
    };

    public AbstractUGraphic(HColor defaultBackground, ColorMapper colorMapper, StringBounder stringBounder, O graphic) {
        super(Objects.requireNonNull(defaultBackground), colorMapper, stringBounder);
        this.graphic = graphic;
    }

    protected AbstractUGraphic(AbstractUGraphic<O> other) {
        super(other);
        this.graphic = other.graphic;
    }

    protected final O getGraphicObject() {
        return this.graphic;
    }

    protected boolean manageHiddenAutomatically() {
        return true;
    }

    protected final <SHAPE extends UShape> void registerDriver(Class<SHAPE> cl, UDriver<SHAPE, O> driver) {
        this.drivers.put(cl, driver);
    }

    protected final <SHAPE extends UShape> void ignoreShape(Class<SHAPE> cl) {
        this.registerDriver(cl, NOOP_DRIVER);
    }

    @Override
    public final <SHAPE extends UShape> void draw(SHAPE shape) {
        if (shape instanceof SpecialText) {
            ((SpecialText)shape).getTitle().drawU(this);
            return;
        }
        if (shape instanceof UEmpty) {
            return;
        }
        if (shape instanceof UComment) {
            this.drawComment((UComment)shape);
            return;
        }
        UDriver<?, O> driver = this.drivers.get(shape.getClass());
        if (driver == null) {
            throw new UnsupportedOperationException(shape.getClass().toString() + " " + this.getClass());
        }
        if (this.getParam().isHidden() && this.manageHiddenAutomatically()) {
            return;
        }
        this.beforeDraw();
        driver.draw(shape, this.getTranslateX(), this.getTranslateY(), this.getColorMapper(), this.getParam(), this.graphic);
        this.afterDraw();
    }

    protected void drawComment(UComment shape) {
    }

    protected void beforeDraw() {
    }

    protected void afterDraw() {
    }
}

