/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic;

import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.CenteredText;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.graphic.SpecialText;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.posimo.DotPath;
import znaishaded.net.sourceforge.plantuml.ugraphic.MinMax;
import znaishaded.net.sourceforge.plantuml.ugraphic.MinMaxMutable;
import znaishaded.net.sourceforge.plantuml.ugraphic.UAntiAliasing;
import znaishaded.net.sourceforge.plantuml.ugraphic.UBackground;
import znaishaded.net.sourceforge.plantuml.ugraphic.UCenteredCharacter;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChange;
import znaishaded.net.sourceforge.plantuml.ugraphic.UClip;
import znaishaded.net.sourceforge.plantuml.ugraphic.UComment;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEmpty;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphicNo;
import znaishaded.net.sourceforge.plantuml.ugraphic.UHidden;
import znaishaded.net.sourceforge.plantuml.ugraphic.UImage;
import znaishaded.net.sourceforge.plantuml.ugraphic.UImageSvg;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPath;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPixel;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UShape;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UText;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.utils.ObjectUtils;

public class LimitFinder
extends UGraphicNo {
    private final MinMaxMutable minmax;
    private UClip clip;
    private static final double HACK_X_FOR_POLYGON = 10.0;

    @Override
    public UGraphic apply(UChange change) {
        UTranslate tmp = change instanceof UTranslate ? this.getTranslate().compose((UTranslate)change) : this.getTranslate();
        LimitFinder result = new LimitFinder(this.getStringBounder(), tmp, this.minmax);
        if (!ObjectUtils.instanceOfAny(change, UAntiAliasing.class, UBackground.class, UClip.class, HColor.class, UHidden.class, UStroke.class, UTranslate.class)) {
            throw new UnsupportedOperationException(change.getClass().toString());
        }
        result.clip = change instanceof UClip ? ((UClip)change).translate(result.getTranslate()) : this.clip;
        return result;
    }

    public static LimitFinder create(StringBounder stringBounder, boolean initToZero) {
        LimitFinder result = new LimitFinder(stringBounder, new UTranslate(), MinMaxMutable.getEmpty(initToZero));
        result.clip = null;
        return result;
    }

    private LimitFinder(StringBounder stringBounder, UTranslate translate, MinMaxMutable minmax) {
        super(stringBounder, translate);
        this.minmax = minmax;
    }

    private void addPoint(double x, double y) {
        if (this.clip == null || this.clip.isInside(x, y)) {
            this.minmax.addPoint(x, y);
        }
    }

    public void draw(UShape shape) {
        double x = this.getTranslate().getDx();
        double y = this.getTranslate().getDy();
        if (shape instanceof UText) {
            this.drawText(x, y, (UText)shape);
        } else if (shape instanceof ULine) {
            this.drawULine(x, y, (ULine)shape);
        } else if (shape instanceof UEllipse) {
            this.drawEllipse(x, y, (UEllipse)shape);
        } else if (shape instanceof UPolygon) {
            this.drawUPolygon(x, y, (UPolygon)shape);
        } else if (shape instanceof UPath) {
            this.drawUPath(x, y, (UPath)shape);
        } else if (shape instanceof URectangle) {
            this.drawRectangle(x, y, (URectangle)shape);
        } else if (shape instanceof DotPath) {
            this.drawDotPath(x, y, (DotPath)shape);
        } else if (shape instanceof UImage) {
            this.drawImage(x, y, (UImage)shape);
        } else if (shape instanceof UImageSvg) {
            this.drawImageSvg(x, y, (UImageSvg)shape);
        } else if (!(shape instanceof UComment)) {
            if (shape instanceof UEmpty) {
                this.drawEmpty(x, y, (UEmpty)shape);
            } else if (shape instanceof TextBlock) {
                TextBlock tb = (TextBlock)shape;
                tb.drawU(this);
            } else if (!(shape instanceof UCenteredCharacter || shape instanceof CenteredText || shape instanceof SpecialText)) {
                if (shape instanceof UPixel) {
                    this.addPoint(x, y);
                } else {
                    throw new UnsupportedOperationException(shape.getClass().getName());
                }
            }
        }
    }

    private void drawEmpty(double x, double y, UEmpty shape) {
        this.addPoint(x, y);
        this.addPoint(x + shape.getWidth(), y + shape.getHeight());
    }

    private void drawUPath(double x, double y, UPath shape) {
        this.addPoint(x + shape.getMinX(), y + shape.getMinY());
        this.addPoint(x + shape.getMaxX(), y + shape.getMaxY());
    }

    private void drawUPolygon(double x, double y, UPolygon shape) {
        if (shape.getPoints().size() == 0) {
            return;
        }
        this.addPoint(x + shape.getMinX() - 10.0, y + shape.getMinY());
        this.addPoint(x + shape.getMaxX() + 10.0, y + shape.getMaxY());
    }

    private void drawULine(double x, double y, ULine shape) {
        this.addPoint(x, y);
        this.addPoint(x + shape.getDX(), y + shape.getDY());
    }

    private void drawRectangle(double x, double y, URectangle shape) {
        this.addPoint(x - 1.0, y - 1.0);
        this.addPoint(x + shape.getWidth() - 1.0 + shape.getDeltaShadow() * 2.0, y + shape.getHeight() - 1.0 + shape.getDeltaShadow() * 2.0);
    }

    private void drawDotPath(double x, double y, DotPath shape) {
        MinMax shapeMinMax = shape.getMinMax();
        this.addPoint(x + shapeMinMax.getMinX(), y + shapeMinMax.getMinY());
        this.addPoint(x + shapeMinMax.getMaxX(), y + shapeMinMax.getMaxY());
    }

    private void drawImage(double x, double y, UImage shape) {
        this.addPoint(x, y);
        this.addPoint(x + (double)shape.getWidth() - 1.0, y + (double)shape.getHeight() - 1.0);
    }

    private void drawImageSvg(double x, double y, UImageSvg shape) {
        this.addPoint(x, y);
        this.addPoint(x + shape.getWidth() - 1.0, y + shape.getHeight() - 1.0);
    }

    private void drawEllipse(double x, double y, UEllipse shape) {
        this.addPoint(x, y);
        this.addPoint(x + shape.getWidth() - 1.0 + shape.getDeltaShadow() * 2.0, y + shape.getHeight() - 1.0 + shape.getDeltaShadow() * 2.0);
    }

    private void drawText(double x, double y, UText text) {
        Dimension2D dim = this.getStringBounder().calculateDimension(text.getFontConfiguration().getFont(), text.getText());
        this.addPoint(x, y -= dim.getHeight() - 1.5);
        this.addPoint(x, y + dim.getHeight());
        this.addPoint(x + dim.getWidth(), y);
        this.addPoint(x + dim.getWidth(), y + dim.getHeight());
    }

    @Override
    public ColorMapper getColorMapper() {
        return new ColorMapperIdentity();
    }

    public double getMaxX() {
        return this.minmax.getMaxX();
    }

    public double getMaxY() {
        return this.minmax.getMaxY();
    }

    public double getMinX() {
        return this.minmax.getMinX();
    }

    public double getMinY() {
        return this.minmax.getMinY();
    }

    public MinMax getMinMax() {
        if (this.minmax.isInfinity()) {
            return MinMax.getEmpty(true);
        }
        return MinMax.fromMutable(this.minmax);
    }
}

