/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.version;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.OptionFlags;
import znaishaded.net.sourceforge.plantuml.version.LicenseInfo;
import znaishaded.net.sourceforge.plantuml.version.LicenseType;
import znaishaded.net.sourceforge.plantuml.windowsdot.WindowsDotArchive;

public enum License {
    GPL,
    GPLV2,
    LGPL,
    APACHE,
    EPL,
    MIT,
    BSD;


    public static License getCurrent() {
        return GPL;
    }

    private void addMit(LicenseInfo licenseInfo, List<String> text) {
        text.add("PlantUML is free software; you can redistribute it and/or modify it");
        text.add("under the terms of the MIT License.");
        text.add(" ");
        text.add("See http://opensource.org/licenses/MIT");
        text.add(" ");
        text.add("Permission is hereby granted, free of charge, to any person obtaining");
        text.add("a copy of this software and associated documentation files (the \"Software\"),");
        text.add("to deal in the Software without restriction, including without limitation");
        text.add("the rights to use, copy, modify, merge, publish, distribute, sublicense,");
        text.add("and/or sell copies of the Software, and to permit persons to whom the");
        text.add("Software is furnished to do so, subject to the following conditions:");
        text.add(" ");
        text.add("The above copyright notice and this permission notice shall be included");
        text.add("in all copies or substantial portions of the Software.");
        text.add(" ");
        text.add("THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS");
        text.add("OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,");
        text.add("FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE");
        text.add("AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,");
        text.add("WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR");
        text.add("IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.");
        text.add(" ");
        this.addSupplementary(licenseInfo, text);
        text.add("the MIT License.");
        text.add(" ");
        text.add("The generated images can then be used without any reference to the MIT License.");
        text.add("It is not even necessary to stipulate that they have been generated with PlantUML,");
        text.add("although this will be appreciated by the PlantUML team.");
        text.add(" ");
        text.add("There is an exception : if the textual description in PlantUML language is also covered");
        text.add("by a license (like the MIT), then the generated images are logically covered");
        text.add("by the very same license.");
    }

    private void addEpl(LicenseInfo licenseInfo, List<String> text) {
        text.add("PlantUML is free software; you can redistribute it and/or modify it");
        text.add("under the terms of the Eclipse Public License.");
        text.add(" ");
        text.add("THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC");
        text.add("LICENSE (\"AGREEMENT\"). [Eclipse Public License - v 1.0]");
        text.add(" ");
        text.add("ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES");
        text.add("RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.");
        text.add(" ");
        text.add("You may obtain a copy of the License at");
        text.add(" ");
        text.add("http://www.eclipse.org/legal/epl-v10.html");
        text.add(" ");
        text.add("Unless required by applicable law or agreed to in writing, software");
        text.add("distributed under the License is distributed on an \"AS IS\" BASIS,");
        text.add("WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.");
        text.add("See the License for the specific language governing permissions and");
        text.add("limitations under the License.");
        text.add(" ");
        this.addSupplementary(licenseInfo, text);
        text.add("the Eclipse Public License.");
        text.add(" ");
        text.add("The generated images can then be used without any reference to the Eclipse Public License.");
        text.add("It is not even necessary to stipulate that they have been generated with PlantUML,");
        text.add("although this will be appreciated by the PlantUML team.");
        text.add(" ");
        text.add("There is an exception : if the textual description in PlantUML language is also covered");
        text.add("by a license (like the EPL), then the generated images are logically covered");
        text.add("by the very same license.");
    }

    private void addBsd(LicenseInfo licenseInfo, List<String> text) {
        text.add("PlantUML is free software; you can redistribute it and/or modify it");
        text.add("under the terms of the Revised BSD License.");
        text.add(" ");
        text.add("All rights reserved.");
        text.add("Redistribution and use in source and binary forms, with or without");
        text.add("modification, are permitted provided that the following conditions are met:");
        text.add(" ");
        text.add("* Redistributions of source code must retain the above copyright");
        text.add("  notice, this list of conditions and the following disclaimer.");
        text.add("* Redistributions in binary form must reproduce the above copyright");
        text.add("  notice, this list of conditions and the following disclaimer in the");
        text.add("  documentation and/or other materials provided with the distribution.");
        text.add("* Neither the name of the University of California, Berkeley nor the");
        text.add("  names of its contributors may be used to endorse or promote products");
        text.add("  derived from this software without specific prior written permission.");
        text.add(" ");
        text.add("THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY");
        text.add("EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED");
        text.add("WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE");
        text.add("DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY");
        text.add("DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES");
        text.add("(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;");
        text.add("LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND");
        text.add("ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT");
        text.add("(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS");
        text.add("SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.");
        text.add(" ");
        this.addSupplementary(licenseInfo, text);
        text.add("the Eclipse Public License.");
        text.add(" ");
        text.add("The generated images can then be used without any reference to the Eclipse Public License.");
        text.add("It is not even necessary to stipulate that they have been generated with PlantUML,");
        text.add("although this will be appreciated by the PlantUML team.");
        text.add(" ");
        text.add("There is an exception : if the textual description in PlantUML language is also covered");
        text.add("by a license (like the BSD), then the generated images are logically covered");
        text.add("by the very same license.");
    }

    private void addApache(LicenseInfo licenseInfo, List<String> text) {
        text.add("PlantUML is free software; you can redistribute it and/or modify it");
        text.add("under the terms of the Apache Software License.");
        text.add(" ");
        text.add("Licensed under the Apache License, Version 2.0 (the \"License\");");
        text.add("you may not use this file except in compliance with the License.");
        text.add("You may obtain a copy of the License at");
        text.add(" ");
        text.add("http://www.apache.org/licenses/LICENSE-2.0");
        text.add(" ");
        text.add("Unless required by applicable law or agreed to in writing, software");
        text.add("distributed under the License is distributed on an \"AS IS\" BASIS,");
        text.add("WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.");
        text.add("See the License for the specific language governing permissions and");
        text.add("limitations under the License.");
        text.add(" ");
        this.addSupplementary(licenseInfo, text);
        text.add("the Apache license.");
        text.add(" ");
        text.add("The generated images can then be used without any reference to the Apache license.");
        text.add("It is not even necessary to stipulate that they have been generated with PlantUML,");
        text.add("although this will be appreciated by the PlantUML team.");
        text.add(" ");
        text.add("There is an exception : if the textual description in PlantUML language is also covered");
        text.add("by a license (like the Apache), then the generated images are logically covered");
        text.add("by the very same license.");
    }

    private void addGpl(LicenseInfo licenseInfo, List<String> text) {
        text.add("PlantUML is free software; you can redistribute it and/or modify it");
        text.add("under the terms of the GNU General Public License as published by");
        text.add("the Free Software Foundation, either version 3 of the License, or");
        text.add("(at your option) any later version.");
        text.add(" ");
        text.add("PlantUML distributed in the hope that it will be useful, but");
        text.add("WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY");
        text.add("or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public");
        text.add("License for more details.");
        text.add(" ");
        text.add("You should have received a copy of the GNU General Public License");
        text.add("along with this library.  If not, see <https://www.gnu.org/licenses/>.");
        text.add(" ");
        this.addSupplementary(licenseInfo, text);
        text.add("the GPL license.");
        text.add(" ");
        text.add("The generated images can then be used without any reference to the GPL license.");
        text.add("It is not even necessary to stipulate that they have been generated with PlantUML,");
        text.add("although this will be appreciated by the PlantUML team.");
        text.add(" ");
        text.add("There is an exception : if the textual description in PlantUML language is also covered");
        text.add("by a license (like the GPL), then the generated images are logically covered");
        text.add("by the very same license.");
    }

    private void addGplV2(LicenseInfo licenseInfo, List<String> text) {
        text.add("PlantUML is free software; you can redistribute it and/or modify it");
        text.add("under the terms of the GNU General Public License as published by");
        text.add("the Free Software Foundation, either version 2 of the License, or");
        text.add("(at your option) any later version.");
        text.add(" ");
        text.add("PlantUML distributed in the hope that it will be useful, but");
        text.add("WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY");
        text.add("or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public");
        text.add("License for more details.");
        text.add(" ");
        text.add("You should have received a copy of the GNU General Public License");
        text.add("along with this library.  If not, see <https://www.gnu.org/licenses/>.");
        text.add(" ");
        this.addSupplementary(licenseInfo, text);
        text.add("the GPL license.");
        text.add(" ");
        text.add("The generated images can then be used without any reference to the GPL license.");
        text.add("It is not even necessary to stipulate that they have been generated with PlantUML,");
        text.add("although this will be appreciated by the PlantUML team.");
        text.add(" ");
        text.add("There is an exception : if the textual description in PlantUML language is also covered");
        text.add("by a license (like the GPL), then the generated images are logically covered");
        text.add("by the very same license.");
    }

    private void addLgpl(LicenseInfo licenseInfo, List<String> text) {
        text.add("PlantUML is free software; you can redistribute it and/or modify it");
        text.add("under the terms of the GNU Lesser General Public License as published by");
        text.add("the Free Software Foundation, either version 3 of the License, or");
        text.add("(at your option) any later version.");
        text.add(" ");
        text.add("PlantUML distributed in the hope that it will be useful, but");
        text.add("WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY");
        text.add("or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public");
        text.add("License for more details.");
        text.add(" ");
        text.add("You should have received a copy of the GNU Lesser General Public License");
        text.add("along with this library.  If not, see <https://www.gnu.org/licenses/>.");
        text.add(" ");
        this.addSupplementary(licenseInfo, text);
        text.add("the LGPL license.");
        text.add(" ");
        text.add("The generated images can then be used without any reference to the LGPL license.");
        text.add("It is not even necessary to stipulate that they have been generated with PlantUML,");
        text.add("although this will be appreciated by the PlantUML team.");
        text.add(" ");
        text.add("There is an exception : if the textual description in PlantUML language is also covered");
        text.add("by a license (like the LGPL), then the generated images are logically covered");
        text.add("by the very same license.");
    }

    private void addSupplementary(LicenseInfo licenseInfo, List<String> text) {
        if (!licenseInfo.isValid()) {
            text.add("PlantUML can occasionally display sponsored or advertising messages. Those");
            text.add("messages are usually generated on welcome or error images and never on");
            text.add("functional diagrams.");
            text.add("See https://plantuml.com/professional if you want to remove them");
            text.add(" ");
        }
        text.add("Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML");
        text.add("are owned by the author of their corresponding sources code (that is, their");
        text.add("textual description in PlantUML language). Those images are not covered by");
    }

    private void header1(List<String> text, LicenseInfo licenseInfo) {
        if (licenseInfo.isNone()) {
            text.add("+=======================================================================");
            text.add("| ");
            text.add("|      PlantUML : a free UML diagram generator");
            text.add("| ");
            text.add("+=======================================================================");
        } else {
            text.add("+=======================================================================");
            text.add("| ");
            text.add("|      PlantUML Professional Edition");
            text.add("| ");
            text.add("+=======================================================================");
            License.addLicenseInfo(text, licenseInfo);
            text.add("+=======================================================================");
        }
    }

    private void header2(List<String> text, LicenseInfo licenseInfo, boolean withQrcode) {
        text.add(" ");
        text.add("(C) Copyright 2009-2023, Arnaud Roques");
        text.add(" ");
        text.add("Project Info:  https://plantuml.com");
        text.add(" ");
        if (!licenseInfo.isValid()) {
            text.add("If you like this project or if you find it useful, you can support us at:");
            text.add(" ");
            text.add("https://plantuml.com/patreon (only 1$ per month!)");
            text.add("https://plantuml.com/liberapay (only 1\u20ac per month!)");
            text.add("https://plantuml.com/paypal");
            if (withQrcode) {
                text.add("\t<qrcode:http://plantuml.com/patreon>\t\t<qrcode:http://plantuml.com/lp>\t\t<qrcode:http://plantuml.com/paypal>");
            } else {
                text.add("");
                text.add(" ");
            }
        }
    }

    public static void addLicenseInfo(List<String> text, LicenseInfo licenseInfo) {
        if (licenseInfo.getLicenseType() == LicenseType.NAMED) {
            text.add("| ");
            text.add("|      LICENSED TO : " + licenseInfo.getOwner());
            text.add("|      EXPIRATION DATE : " + DateFormat.getDateInstance().format(licenseInfo.getExpirationDate()));
            text.add("|  ");
        } else if (licenseInfo.getLicenseType() == LicenseType.DISTRIBUTOR) {
            text.add("|  ");
            text.add("|      DISTRIBUTED BY : " + licenseInfo.getOwner());
            text.add("|  ");
        }
        if (licenseInfo.getLicenseType() != LicenseType.UNKNOWN && licenseInfo.hasExpired()) {
            text.add("|      <i>Warning: Your license has expired.");
            text.add("|  ");
        }
    }

    public List<String> getJavaHeader(List<String> contributors) {
        ArrayList<String> h2 = new ArrayList<String>();
        h2.add("/* ========================================================================");
        h2.add(" * PlantUML : a free UML diagram generator");
        h2.add(" * ========================================================================");
        h2.add(" *");
        h2.add(" * (C) Copyright 2009-2023, Arnaud Roques");
        h2.add(" *");
        h2.add(" * Project Info:  https://plantuml.com");
        h2.add(" * ");
        h2.add(" * If you like this project or if you find it useful, you can support us at:");
        h2.add(" * ");
        h2.add(" * https://plantuml.com/patreon (only 1$ per month!)");
        h2.add(" * https://plantuml.com/paypal");
        h2.add(" * ");
        h2.add(" * This file is part of PlantUML.");
        h2.add(" *");
        if (this == LGPL) {
            h2.add(" * PlantUML is free software; you can redistribute it and/or modify it");
            h2.add(" * under the terms of the GNU Lesser General Public License as published by");
            h2.add(" * the Free Software Foundation, either version 3 of the License, or");
            h2.add(" * (at your option) any later version.");
            h2.add(" *");
            h2.add(" * PlantUML distributed in the hope that it will be useful, but");
            h2.add(" * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY");
            h2.add(" * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public");
            h2.add(" * License for more details.");
            h2.add(" *");
            h2.add(" * You should have received a copy of the GNU General Public License");
            h2.add(" * along with this library.  If not, see <https://www.gnu.org/licenses/>.");
            h2.add(" *");
        } else if (this == GPLV2) {
            h2.add(" * PlantUML is free software; you can redistribute it and/or modify it");
            h2.add(" * under the terms of the GNU General Public License as published by");
            h2.add(" * the Free Software Foundation, either version 2 of the License, or");
            h2.add(" * (at your option) any later version.");
            h2.add(" *");
            h2.add(" * PlantUML distributed in the hope that it will be useful, but");
            h2.add(" * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY");
            h2.add(" * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public");
            h2.add(" * License for more details.");
            h2.add(" *");
            h2.add(" * You should have received a copy of the GNU General Public License");
            h2.add(" * along with this library.  If not, see <https://www.gnu.org/licenses/>.");
            h2.add(" *");
        } else if (this == APACHE) {
            h2.add(" * Licensed under the Apache License, Version 2.0 (the \"License\");");
            h2.add(" * you may not use this file except in compliance with the License.");
            h2.add(" * You may obtain a copy of the License at");
            h2.add(" * ");
            h2.add(" * http://www.apache.org/licenses/LICENSE-2.0");
            h2.add(" * ");
            h2.add(" * Unless required by applicable law or agreed to in writing, software");
            h2.add(" * distributed under the License is distributed on an \"AS IS\" BASIS,");
            h2.add(" * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.");
            h2.add(" * See the License for the specific language governing permissions and");
            h2.add(" * limitations under the License.");
            h2.add(" *");
        } else if (this == EPL) {
            h2.add(" * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC");
            h2.add(" * LICENSE (\"AGREEMENT\"). [Eclipse Public License - v 1.0]");
            h2.add(" * ");
            h2.add(" * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES");
            h2.add(" * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.");
            h2.add(" * ");
            h2.add(" * You may obtain a copy of the License at");
            h2.add(" * ");
            h2.add(" * http://www.eclipse.org/legal/epl-v10.html");
            h2.add(" * ");
            h2.add(" * Unless required by applicable law or agreed to in writing, software");
            h2.add(" * distributed under the License is distributed on an \"AS IS\" BASIS,");
            h2.add(" * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.");
            h2.add(" * See the License for the specific language governing permissions and");
            h2.add(" * limitations under the License.");
            h2.add(" * ");
        } else if (this == BSD) {
            h2.add(" * Licensed under the Revised BSD License (the Revised Berkeley Software Distribution)");
            h2.add(" * ");
            h2.add(" * Redistribution and use in source and binary forms, with or without");
            h2.add(" * modification, are permitted provided that the following conditions are met:");
            h2.add(" * ");
            h2.add(" * * Redistributions of source code must retain the above copyright");
            h2.add(" *   notice, this list of conditions and the following disclaimer.");
            h2.add(" * * Redistributions in binary form must reproduce the above copyright");
            h2.add(" *   notice, this list of conditions and the following disclaimer in the");
            h2.add(" *   documentation and/or other materials provided with the distribution.");
            h2.add(" * * Neither the name of the University of California, Berkeley nor the");
            h2.add(" *   names of its contributors may be used to endorse or promote products");
            h2.add(" *   derived from this software without specific prior written permission.");
            h2.add(" * ");
            h2.add(" * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY");
            h2.add(" * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED");
            h2.add(" * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE");
            h2.add(" * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY");
            h2.add(" * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES");
            h2.add(" * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;");
            h2.add(" * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND");
            h2.add(" * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT");
            h2.add(" * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS");
            h2.add(" * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.");
            h2.add(" * ");
        } else if (this == MIT) {
            h2.add(" * Licensed under The MIT License (Massachusetts Institute of Technology License)");
            h2.add(" * ");
            h2.add(" * See http://opensource.org/licenses/MIT");
            h2.add(" * ");
            h2.add(" * Permission is hereby granted, free of charge, to any person obtaining");
            h2.add(" * a copy of this software and associated documentation files (the \"Software\"),");
            h2.add(" * to deal in the Software without restriction, including without limitation");
            h2.add(" * the rights to use, copy, modify, merge, publish, distribute, sublicense,");
            h2.add(" * and/or sell copies of the Software, and to permit persons to whom the");
            h2.add(" * Software is furnished to do so, subject to the following conditions:");
            h2.add(" * ");
            h2.add(" * The above copyright notice and this permission notice shall be included");
            h2.add(" * in all copies or substantial portions of the Software.");
            h2.add(" * ");
            h2.add(" * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS");
            h2.add(" * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,");
            h2.add(" * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE");
            h2.add(" * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,");
            h2.add(" * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR");
            h2.add(" * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.");
            h2.add(" * ");
        }
        h2.add(" *");
        h2.add(" * Original Author:  Arnaud Roques");
        h2.addAll(contributors);
        h2.add(" */");
        return Collections.unmodifiableList(h2);
    }

    public List<String> getTextFull() {
        LicenseInfo licenseInfo = LicenseInfo.retrieveQuick();
        ArrayList<String> text = new ArrayList<String>();
        this.header1(text, licenseInfo);
        this.header2(text, licenseInfo, false);
        this.end3(text, licenseInfo);
        return text;
    }

    public List<String> getText1(LicenseInfo licenseInfo) {
        ArrayList<String> text = new ArrayList<String>();
        this.header1(text, licenseInfo);
        return text;
    }

    public List<String> getText2(LicenseInfo licenseInfo) {
        ArrayList<String> text = new ArrayList<String>();
        this.header2(text, licenseInfo, true);
        this.end3(text, licenseInfo);
        return text;
    }

    private void end3(List<String> text, LicenseInfo licenseInfo) {
        if (this == GPL) {
            this.addGpl(licenseInfo, text);
        } else if (this == GPLV2) {
            this.addGplV2(licenseInfo, text);
        } else if (this == MIT) {
            this.addMit(licenseInfo, text);
        } else if (this == EPL) {
            this.addEpl(licenseInfo, text);
        } else if (this == BSD) {
            this.addBsd(licenseInfo, text);
        } else if (this == APACHE) {
            this.addApache(licenseInfo, text);
        } else if (this == LGPL) {
            this.addLgpl(licenseInfo, text);
        } else {
            throw new IllegalStateException();
        }
        if (OptionFlags.getInstance().isEnableStats()) {
            text.add(" ");
            text.add("This version of PlantUML records general local statistics about usage.");
            text.add("(more info on https://plantuml.com/statistics-report)");
        }
        text.add(" ");
        if (WindowsDotArchive.getInstance().isThereArchive()) {
            text.add("This distribution bundles a minimal set of GraphViz files and may install them");
            text.add(" if needed in the local temporary directory.");
        } else {
            text.add("This is the IGY distribution (Install GraphViz by Yourself).");
            text.add("You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable");
        }
        text.add("(see https://plantuml.com/graphviz-dot )");
        text.add(" ");
        text.add("Icons provided by OpenIconic :  https://useiconic.com/open");
        text.add("Archimate sprites provided by Archi :  http://www.archimatetool.com");
        text.add("Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML");
        text.add("Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites");
        text.add("ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen");
        text.add("ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman");
        text.add("CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli");
        text.add("Brotli (c) by the Brotli Authors https://github.com/google/brotli");
        text.add("Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes");
        text.add("Twemoji (c) by Twitter at https://twemoji.twitter.com/");
        text.add(" ");
    }
}

