/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.apache.ant.compress.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import znaishaded.org.apache.ant.compress.util.CompressorStreamFactory;
import znaishaded.org.apache.commons.compress.compressors.CompressorInputStream;
import znaishaded.org.apache.commons.compress.compressors.CompressorOutputStream;
import znaishaded.org.apache.commons.compress.compressors.snappy.FramedSnappyCompressorInputStream;
import znaishaded.org.apache.commons.compress.compressors.snappy.FramedSnappyCompressorOutputStream;
import znaishaded.org.apache.commons.compress.compressors.snappy.SnappyCompressorInputStream;

public class SnappyStreamFactory
implements CompressorStreamFactory {
    private boolean framed = true;

    public void setFramed(boolean framed) {
        this.framed = framed;
    }

    protected boolean isFramed() {
        return this.framed;
    }

    @Override
    public CompressorInputStream getCompressorStream(InputStream stream) throws IOException {
        return this.framed ? new FramedSnappyCompressorInputStream(stream) : new SnappyCompressorInputStream(stream);
    }

    @Override
    public CompressorOutputStream getCompressorStream(OutputStream stream) throws IOException {
        if (!this.framed) {
            throw new UnsupportedOperationException("Must know the uncompressed size for non-framed snappy");
        }
        return new FramedSnappyCompressorOutputStream(stream);
    }
}

