# Operation By Method And Path

If you have a file with an [Open API](https://github.com/OAI/OpenAPI-Specification/blob/master/README.md)
definition (a.k.a. a Swagger file) you can render it by a given `method` and `path`, or by `operationId`. 
Both `yaml` and `json` formats are supported.

Let's consider [Uber's API definition](https://github.com/OAI/OpenAPI-Specification/blob/master/examples/v2.0/json/uber.json) as an example:

    :include-open-api: open-api/uber.json {method: "get", path: "/estimates/time"}
    
:include-open-api: open-api/uber.json {method: "get", path: "/estimates/time"}

Note: descriptions are treated as Markdown, using the [CommonMark](https://commonmark.org/help/) specification

# Operation By ID

Let's take a pet store example. Use `operationId` to include operation definition by ID.

    :include-open-api: petstore-openapi3.json {operationId: "updatePet"}

:include-open-api: petstore-openapi3.json {operationId: "updatePet"}

# Auto Section

Use the `autoSection` property to automatically generate a page section with a title taken from an operation summary.

    :include-open-api: petstore-openapi3.json {operationId: "addPet", autoSection: true}

Note: The section below is automatically generated by `include-open-api` 

:include-open-api: petstore-openapi3.json {operationId: "addPet", autoSection: true}

# Tags

Specify `tags` to automatically generate multiple entries from a service definition file.

    :include-open-api: open-api/uber.yaml {tags: "Estimates", autoSection: true}

Note: The sections below are automatically generated by `include-open-api` 

:include-open-api: open-api/uber.yaml {tags: "Estimates", autoSection: true}
 
# Two Sides Layout

Znai supports [Two Sides](layout/two-sides-pages) Layout mode that is perfect to supplement API documentation with examples column.

[Open API example](layout/two-sides-pages#open-api-example)
