/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.card;

import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParamType;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinitionCommon;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.fence.FencePlugin;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;
import org.testingisdocumenting.znai.utils.UrlUtils;

public class CardFencePlugin
implements FencePlugin {
    private static final String IMAGE_SRC_KEY = "imageSrc";
    private static final String IMAGE_HEIGHT_KEY = "imageHeight";
    private static final String IMAGE_BACKGROUND_KEY = "imageBackground";
    private AuxiliaryFile imageAuxiliaryFile;
    private MarkupParserResult contentParseResult;
    private boolean isExternal;
    private ComponentsRegistry componentsRegistry;

    @Override
    public String id() {
        return "card";
    }

    @Override
    public FencePlugin create() {
        return new CardFencePlugin();
    }

    @Override
    public PluginParamsDefinition parameters() {
        return new PluginParamsDefinition().add(PluginParamsDefinitionCommon.title).add(IMAGE_HEIGHT_KEY, PluginParamType.NUMBER, "force image height", "100").add(IMAGE_BACKGROUND_KEY, PluginParamType.STRING, "image background gradient/color", "#aere83");
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        if (this.imageAuxiliaryFile != null) {
            return Stream.of(this.imageAuxiliaryFile);
        }
        return Stream.empty();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, Path markupPath, PluginParams pluginParams, String content) {
        this.componentsRegistry = componentsRegistry;
        String imageSrc = pluginParams.getFreeParam();
        this.isExternal = UrlUtils.isExternal(imageSrc);
        this.imageAuxiliaryFile = this.createAuxiliaryFileIfRequired(imageSrc);
        this.contentParseResult = componentsRegistry.markdownParser().parse(markupPath, content);
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(pluginParams.getOpts().toMap());
        if (this.isExternal) {
            props.put(IMAGE_SRC_KEY, imageSrc);
        } else if (this.imageAuxiliaryFile != null) {
            props.put(IMAGE_SRC_KEY, componentsRegistry.docStructure().fullUrl(this.imageAuxiliaryFile.getDeployRelativePath().toString()));
        }
        props.put("bodyContent", this.contentParseResult.contentToListOfMaps());
        return PluginResult.docElement("Card", props);
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.STANDARD.text(this.contentParseResult.getAllText());
    }

    private AuxiliaryFile createAuxiliaryFileIfRequired(String imageSrc) {
        if (imageSrc.isEmpty()) {
            return null;
        }
        if (this.isExternal) {
            return null;
        }
        return this.componentsRegistry.resourceResolver().runtimeAuxiliaryFile(imageSrc);
    }
}

