/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.file;

import java.util.ArrayList;
import java.util.List;
import org.testingisdocumenting.znai.extensions.file.SnippetContentProvider;

public class SnippetContainerEntriesConverter {
    private final String[] lines;
    private final String label;
    private final String content;
    private final String snippetId;

    public SnippetContainerEntriesConverter(SnippetContentProvider provider, String label) {
        this.label = label;
        this.content = provider.snippetContent();
        this.snippetId = provider.snippetId();
        this.lines = this.content.split("\n");
    }

    public List<Integer> convertAndValidate(List<Object> idxOrContains) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Object idxOrText : idxOrContains) {
            if (idxOrText instanceof Number) {
                result.add(this.validateIdx((Number)idxOrText));
                continue;
            }
            result.addAll(this.validateContainsAndGetIdx((String)idxOrText));
        }
        return result;
    }

    public int validateIdx(Number idx) {
        int idxInt = idx.intValue();
        if (idxInt >= this.lines.length || idxInt < 0) {
            throw new IllegalArgumentException(this.label + " idx is out of range: " + idx + this.exceptionIdMessage());
        }
        return idxInt;
    }

    public List<Integer> findAllContainsIdx(String partial) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int idx = 0;
        for (String line : this.lines) {
            if (line.contains(partial)) {
                result.add(idx);
            }
            ++idx;
        }
        return result;
    }

    public List<Integer> validateContainsAndGetIdx(String partial) {
        List<Integer> containsIndexes = this.findAllContainsIdx(partial);
        if (containsIndexes.isEmpty()) {
            throw new IllegalArgumentException(this.label + " text <" + partial + "> is not found" + this.exceptionIdMessage() + "\n" + this.content);
        }
        return containsIndexes;
    }

    private String exceptionIdMessage() {
        if (this.snippetId.isEmpty()) {
            return "";
        }
        return "\ncheck: " + this.snippetId;
    }
}

