/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.image;

import java.awt.image.BufferedImage;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.fence.FencePlugin;
import org.testingisdocumenting.znai.extensions.image.CsvAnnotations;
import org.testingisdocumenting.znai.extensions.image.ImagePluginBase;

public class ImageFencePlugin
extends ImagePluginBase
implements FencePlugin {
    private ComponentsRegistry componentsRegistry;
    private Path markupPath;
    private String content;

    @Override
    public FencePlugin create() {
        return new ImageFencePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, Path markupPath, PluginParams pluginParams, String content) {
        this.componentsRegistry = componentsRegistry;
        this.markupPath = markupPath;
        this.content = content;
        return this.process(componentsRegistry, markupPath, pluginParams);
    }

    @Override
    protected List<Map<String, Object>> annotationShapes(BufferedImage image) {
        return new CsvAnnotations(this.componentsRegistry.markdownParser(), this.markupPath, image, this.pixelRatio()).annotationsShapesFromCsv(this.content);
    }

    @Override
    protected Double pixelRatio() {
        if (this.pixelRatioFromOpts != null) {
            return this.pixelRatioFromOpts;
        }
        return 1.0;
    }

    @Override
    protected PluginParamsDefinition additionalParameters() {
        return PluginParamsDefinition.undefined();
    }

    @Override
    protected Stream<AuxiliaryFile> additionalAuxiliaryFiles() {
        return Stream.empty();
    }
}

