/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.image;

import java.awt.image.BufferedImage;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.Plugin;
import org.testingisdocumenting.znai.extensions.PluginParamType;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinitionCommon;
import org.testingisdocumenting.znai.extensions.PluginParamsOpts;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.file.AnchorFeature;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.structure.DocStructure;
import org.testingisdocumenting.znai.structure.DocUrl;
import org.testingisdocumenting.znai.utils.UrlUtils;

abstract class ImagePluginBase
implements Plugin {
    private static final List<String> ALIGN_VALUES = Arrays.asList("left", "center", "right");
    protected static final String ALIGN_KEY = "align";
    protected static final String BORDER_KEY = "border";
    protected static final String TITLE_KEY = "title";
    protected static final String CAPTION_KEY = "caption";
    protected static final String CAPTION_BOTTOM_KEY = "captionBottom";
    protected static final String FIT_KEY = "fit";
    protected static final String SCALE_KEY = "scale";
    protected static final String SCALE_DEPRECATED_KEY = "scaleRatio";
    private static final String PIXEL_RATIO_KEY = "pixelRatio";
    private static final String MOBILE_ONLY_KEY = "mobileOnly";
    private static final String DESKTOP_ONLY_KEY = "desktopOnly";
    protected AuxiliaryFile auxiliaryFile;
    protected boolean isExternal;
    protected Double pixelRatioFromOpts;

    ImagePluginBase() {
    }

    @Override
    public PluginParamsDefinition parameters() {
        PluginParamsDefinition params = new PluginParamsDefinition();
        params.add(PluginParamsDefinitionCommon.container);
        params.add(CAPTION_KEY, PluginParamType.STRING, "image title", "\"my image\"");
        params.add(CAPTION_BOTTOM_KEY, PluginParamType.BOOLEAN, "place image title at the bottom", "true");
        params.add(ALIGN_KEY, PluginParamType.STRING, "horizontal image alignment", ALIGN_VALUES.stream().map(v -> "\"" + v + "\"").collect(Collectors.joining(", ")));
        params.add(MOBILE_ONLY_KEY, PluginParamType.BOOLEAN, "render image only for mobile screen size", "true");
        params.add(DESKTOP_ONLY_KEY, PluginParamType.BOOLEAN, "render image only for desktop screen size", "true");
        params.add(BORDER_KEY, PluginParamType.BOOLEAN, "use border around image", "true");
        params.add(FIT_KEY, PluginParamType.BOOLEAN, "fit image to the text width", "true");
        params.add(SCALE_DEPRECATED_KEY, PluginParamType.NUMBER, "[deprecated] image scale ratio", "0.5");
        params.add(SCALE_KEY, PluginParamType.NUMBER, "image scale ratio", "0.5");
        params.add(PIXEL_RATIO_KEY, PluginParamType.NUMBER, "pixel ratio for hi-dpi images, effect is similar to scale, e.g. 2.0 is the same as scale 0.5. The difference is pixelRatio affects annotation coordinates so they need to be supplied using smaller numbers ", "2.0");
        params.add(this.additionalParameters());
        return params;
    }

    @Override
    public String id() {
        return "image";
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        if (this.isExternal) {
            return this.additionalAuxiliaryFiles();
        }
        return Stream.concat(Stream.of(this.auxiliaryFile), this.additionalAuxiliaryFiles());
    }

    protected abstract List<Map<String, Object>> annotationShapes(BufferedImage var1);

    protected abstract Double pixelRatio();

    protected abstract PluginParamsDefinition additionalParameters();

    protected abstract Stream<AuxiliaryFile> additionalAuxiliaryFiles();

    protected PluginResult process(ComponentsRegistry componentsRegistry, Path markupPath, PluginParams pluginParams) {
        PluginParamsOpts opts = pluginParams.getOpts();
        this.pixelRatioFromOpts = opts.has(PIXEL_RATIO_KEY) ? Double.valueOf(opts.getNumber(PIXEL_RATIO_KEY).doubleValue()) : null;
        ResourcesResolver resourceResolver = componentsRegistry.resourceResolver();
        DocStructure docStructure = componentsRegistry.docStructure();
        String imagePath = pluginParams.getFreeParam();
        this.validateAlign(opts);
        this.isExternal = UrlUtils.isExternal(imagePath);
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(opts.toMap());
        if (this.isExternal) {
            props.put("imageSrc", imagePath);
            props.put("shapes", this.annotationShapes(null));
            docStructure.validateUrl(markupPath, "<image plugin>", new DocUrl(imagePath));
        } else {
            this.auxiliaryFile = resourceResolver.runtimeAuxiliaryFile(imagePath);
            BufferedImage bufferedImage = resourceResolver.imageContent(imagePath);
            props.put("imageSrc", docStructure.fullUrl(this.auxiliaryFile.getDeployRelativePath().toString()));
            props.put("timestamp", componentsRegistry.timeService().fileModifiedTimeMillis(this.auxiliaryFile.getPath()));
            props.put("shapes", this.annotationShapes(bufferedImage));
            this.setWidthHeight(bufferedImage, props);
        }
        ImagePluginBase.updatePropsScale(props, opts);
        ImagePluginBase.updateTitleProp(props, opts);
        new AnchorFeature(docStructure, markupPath, pluginParams).updateProps(props);
        return PluginResult.docElement("AnnotatedImage", props);
    }

    private void validateAlign(PluginParamsOpts opts) {
        if (!opts.has(ALIGN_KEY)) {
            return;
        }
        String align = (String)opts.get(ALIGN_KEY);
        if (!ALIGN_VALUES.contains(align)) {
            throw new IllegalArgumentException("<align> only accept following values: " + ALIGN_VALUES.stream().map(v -> "\"" + v + "\"").collect(Collectors.joining(", ")));
        }
    }

    private void setWidthHeight(BufferedImage bufferedImage, Map<String, Object> props) {
        Double pixelRatio = this.pixelRatio();
        props.put("width", (double)bufferedImage.getWidth() / pixelRatio);
        props.put("height", (double)bufferedImage.getHeight() / pixelRatio);
    }

    private static void updatePropsScale(Map<String, Object> props, PluginParamsOpts opts) {
        if (opts.has(SCALE_DEPRECATED_KEY)) {
            props.put(SCALE_KEY, opts.getNumber(SCALE_DEPRECATED_KEY));
        } else if (opts.has(SCALE_KEY)) {
            props.put(SCALE_KEY, opts.getNumber(SCALE_KEY));
        }
    }

    private static void updateTitleProp(Map<String, Object> props, PluginParamsOpts opts) {
        if (opts.has(TITLE_KEY)) {
            props.put(TITLE_KEY, opts.get(TITLE_KEY));
        } else if (opts.has(CAPTION_KEY)) {
            props.put(TITLE_KEY, opts.get(CAPTION_KEY));
        }
    }
}

