/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.image;

import java.awt.image.BufferedImage;
import org.testingisdocumenting.znai.extensions.image.ImageUtils;
import org.testingisdocumenting.znai.extensions.image.RectCoord;

class ShapeColorAnalyzer {
    private final BufferedImage image;
    private final Double pixelRatio;

    ShapeColorAnalyzer(BufferedImage image, Double pixelRatio) {
        this.image = image;
        this.pixelRatio = pixelRatio;
    }

    boolean isDarkCoordinate(Number x, Number y) {
        return ImageUtils.colorDarknessRatio(this.image, (int)(x.doubleValue() * this.pixelRatio), (int)(y.doubleValue() * this.pixelRatio), (int)(10.0 * this.pixelRatio)) > 0.5;
    }

    boolean isDarkBasedOnOppositeCorners(RectCoord rectCoord) {
        return this.isDarkCoordinate(rectCoord.getBeginX(), rectCoord.getBeginY()) || this.isDarkCoordinate(rectCoord.getEndX(), rectCoord.getEndY());
    }

    boolean isDarkBasedOnAllCorners(RectCoord rectCoord) {
        int numberOfDarkAreas = 0;
        if (this.isDarkCoordinate(rectCoord.getBeginX(), rectCoord.getBeginY())) {
            ++numberOfDarkAreas;
        }
        if (this.isDarkCoordinate(rectCoord.getBeginX(), rectCoord.getEndY())) {
            ++numberOfDarkAreas;
        }
        if (this.isDarkCoordinate(rectCoord.getEndX(), rectCoord.getBeginY())) {
            ++numberOfDarkAreas;
        }
        if (this.isDarkCoordinate(rectCoord.getEndX(), rectCoord.getEndY())) {
            ++numberOfDarkAreas;
        }
        return numberOfDarkAreas >= 2;
    }
}

