/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.json;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.Plugin;
import org.testingisdocumenting.znai.extensions.PluginParamType;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinitionCommon;
import org.testingisdocumenting.znai.extensions.PluginParamsOpts;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.features.PluginFeature;
import org.testingisdocumenting.znai.extensions.features.PluginFeatureList;
import org.testingisdocumenting.znai.extensions.file.CodeReferencesFeature;
import org.testingisdocumenting.znai.extensions.file.SnippetHighlightFeature;
import org.testingisdocumenting.znai.extensions.json.JsonPaths;
import org.testingisdocumenting.znai.extensions.validation.EntryPresenceValidation;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.utils.JsonUtils;
import znaishaded.com.jayway.jsonpath.JsonPath;
import znaishaded.com.jayway.jsonpath.Predicate;

public abstract class JsonBasePlugin
implements Plugin {
    private static final String INCLUDE_KEY = "include";
    private static final String PATHS_KEY = "paths";
    private static final String PATHS_FILE_KEY = "pathsFile";
    private static final String COLLAPSED_PATHS_KEY = "collapsedPaths";
    private Path pathsFilePath;
    protected PluginFeatureList features;
    protected ResourcesResolver resourcesResolver;

    @Override
    public String id() {
        return "json";
    }

    @Override
    public PluginParamsDefinition parameters() {
        PluginParamsDefinition params = new PluginParamsDefinition().add(PluginParamsDefinitionCommon.title).add(INCLUDE_KEY, PluginParamType.STRING, "json path to include", "$..book[0,1]").add(PATHS_KEY, PluginParamType.LIST_OR_SINGLE_STRING, "path(s) to leaf values to highlight", "\"root.store.book[0].category\" or [\"root.store.book[0].category\", \"root.store.book[2].category\"]").add(PATHS_FILE_KEY, PluginParamType.STRING, "path to a json file with list of paths to highlight inside", "\"paths.json\"").add(COLLAPSED_PATHS_KEY, PluginParamType.LIST_OR_SINGLE_STRING, "path(s) to nodes to collapse initially", "\"root.store.book\" or [\"root.store.book\", \"root.store.discount\"]").add(SnippetHighlightFeature.paramsDefinition).add(PluginParamsDefinitionCommon.snippetReadMore).add(CodeReferencesFeature.paramsDefinition);
        this.updateParams(params);
        return params;
    }

    public PluginResult commonProcess(ComponentsRegistry componentsRegistry, Path markupPath, PluginParams pluginParams, String jsonText) {
        this.resourcesResolver = componentsRegistry.resourceResolver();
        String jsonPath = pluginParams.getOpts().get(INCLUDE_KEY, "$");
        Object parsed = JsonPath.read(jsonText, jsonPath, new Predicate[0]);
        this.features = new PluginFeatureList(new CodeReferencesFeature(componentsRegistry, markupPath, pluginParams));
        this.additionalPluginFeatures().forEach(this.features::add);
        Set<String> existingPaths = JsonBasePlugin.buildPaths(parsed);
        List<String> paths = this.extractPaths(pluginParams.getOpts());
        EntryPresenceValidation.validateItemsPresence(PATHS_KEY, "JSON", existingPaths, paths);
        List<String> collapsedPaths = pluginParams.getOpts().getList(COLLAPSED_PATHS_KEY);
        EntryPresenceValidation.validateItemsPresence(COLLAPSED_PATHS_KEY, "JSON", existingPaths, collapsedPaths);
        Map<String, Object> props = pluginParams.getOpts().toMap();
        props.put("data", parsed);
        props.put(PATHS_KEY, paths);
        this.features.updateProps(props);
        return PluginResult.docElement("Json", props);
    }

    protected abstract void updateParams(PluginParamsDefinition var1);

    protected abstract Stream<PluginFeature> additionalPluginFeatures();

    protected abstract Stream<AuxiliaryFile> additionalAuxiliaryFiles();

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        Stream pathsFile = this.pathsFilePath == null ? Stream.empty() : Stream.of(AuxiliaryFile.builtTime(this.pathsFilePath));
        return Stream.concat(pathsFile, Stream.concat(this.features.auxiliaryFiles(), this.additionalAuxiliaryFiles()));
    }

    private List<String> extractPaths(PluginParamsOpts opts) {
        if (opts.has(PATHS_FILE_KEY)) {
            String filePath = (String)opts.get(PATHS_FILE_KEY);
            this.pathsFilePath = this.resourcesResolver.fullPath(filePath);
            return JsonUtils.deserializeAsList(this.resourcesResolver.textContent(filePath));
        }
        return opts.getList(PATHS_KEY);
    }

    private static Set<String> buildPaths(Object json) {
        return new JsonPaths(json).getPaths();
    }
}

