/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.json;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class JsonPaths {
    private final Set<String> paths = new LinkedHashSet<String>();

    JsonPaths(Object json) {
        this.buildPaths("root", json);
    }

    public Set<String> getPaths() {
        return this.paths;
    }

    private void buildPaths(String path, Object json) {
        this.paths.add(path);
        this.handleList(path, json);
        this.handleMap(path, json);
    }

    private void handleList(String path, Object json) {
        if (!(json instanceof List)) {
            return;
        }
        List list = (List)json;
        int idx = 0;
        for (Object v : list) {
            this.buildPaths(path + "[" + idx + "]", v);
            ++idx;
        }
    }

    private void handleMap(String path, Object json) {
        if (!(json instanceof Map)) {
            return;
        }
        Map map = (Map)json;
        map.forEach((k, v) -> this.buildPaths(path + "." + k, v));
    }
}

