/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.parser.PageSectionIdTitle;
import org.testingisdocumenting.znai.structure.PageMeta;
import org.testingisdocumenting.znai.structure.TocNameAndOpts;
import org.testingisdocumenting.znai.utils.NameUtils;

public class TocItem {
    private static final Pattern fileNameAllowedPattern = Pattern.compile("[a-zA-Z\\d-_]*");
    public static final String INDEX = "index";
    private final TocNameAndOpts chapter;
    private final String fileNameWithoutExtension;
    private String pageTitle;
    private PageMeta pageMeta;
    private String viewOnRelativePath;
    private List<PageSectionIdTitle> pageSectionIdTitles;

    static TocItem createIndex(String docTitle) {
        TocItem tocItem = new TocItem(new TocNameAndOpts(""), INDEX);
        tocItem.setPageTitle(docTitle);
        return tocItem;
    }

    public TocItem(TocNameAndOpts chapter, String fileNameWithoutExtension) {
        this.chapter = chapter;
        this.fileNameWithoutExtension = fileNameWithoutExtension;
        this.validateFileName(chapter.getGivenName());
        this.validateFileName(this.fileNameWithoutExtension);
        this.pageTitle = NameUtils.dashToCamelCaseWithSpaces(fileNameWithoutExtension);
        this.pageMeta = new PageMeta(Collections.emptyMap());
        this.pageSectionIdTitles = new ArrayList<PageSectionIdTitle>();
    }

    public TocItem(String dirName, String fileNameWithoutExtension, String chapterTitle) {
        this(new TocNameAndOpts(dirName), fileNameWithoutExtension);
        this.chapter.setHumanReadableName(chapterTitle);
    }

    public String getDirName() {
        return this.chapter.getGivenName();
    }

    public String getFileNameWithoutExtension() {
        return this.fileNameWithoutExtension;
    }

    public String getChapterTitle() {
        return this.chapter.getHumanReadableName();
    }

    public String getPageTitle() {
        return this.pageTitle;
    }

    public void setPageMeta(PageMeta pageMeta) {
        this.pageMeta = pageMeta;
    }

    public void setViewOnRelativePath(String viewOnRelativePath) {
        this.viewOnRelativePath = viewOnRelativePath;
    }

    public String getViewOnRelativePath() {
        return this.viewOnRelativePath;
    }

    public List<PageSectionIdTitle> getPageSectionIdTitles() {
        return this.pageSectionIdTitles;
    }

    public boolean hasPageSection(String id) {
        return this.pageSectionIdTitles.stream().anyMatch(ps -> ps.getId().equals(id));
    }

    public void setPageSectionIdTitles(List<PageSectionIdTitle> pageSectionIdTitles) {
        this.pageSectionIdTitles = pageSectionIdTitles;
    }

    public void setPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
    }

    public boolean isIndex() {
        return this.chapter.getGivenName().isEmpty() && this.fileNameWithoutExtension.equals(INDEX);
    }

    public boolean match(String dirName, String fileNameWithoutExtension) {
        return this.getDirName().equals(dirName) && this.getFileNameWithoutExtension().equals(fileNameWithoutExtension);
    }

    public Map<String, ?> toMap() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("chapterTitle", this.getChapterTitle());
        result.put("pageTitle", this.getPageTitle());
        result.put("pageMeta", this.pageMeta.toMap());
        result.put("dirName", this.getDirName());
        result.put("fileName", this.getFileNameWithoutExtension());
        result.put("viewOnRelativePath", this.viewOnRelativePath);
        result.put("pageSectionIdTitles", this.getPageSectionIdTitles().stream().map(PageSectionIdTitle::toMap).collect(Collectors.toList()));
        return result;
    }

    public String toString() {
        return this.chapter.getGivenName() + "/" + this.fileNameWithoutExtension;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TocItem tocItem = (TocItem)o;
        return this.chapter.getGivenName().equals(tocItem.chapter.getGivenName()) && this.fileNameWithoutExtension.equals(tocItem.fileNameWithoutExtension);
    }

    public int hashCode() {
        int result = this.chapter.getGivenName().hashCode();
        result = 31 * result + this.fileNameWithoutExtension.hashCode();
        return result;
    }

    private void validateFileName(String name) {
        if (!fileNameAllowedPattern.matcher(name).matches()) {
            throw new IllegalArgumentException("file name should match: " + fileNameAllowedPattern + "\ngiven name: " + name + "\nuse\n---\ntitle: my custom title with any symbols like !#?\n---\nto override the title for your page");
        }
    }
}

