/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.helpers;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import znaishaded.com.github.fge.jackson.NodeType;
import znaishaded.com.github.fge.jackson.jsonpointer.JsonPointer;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.AbstractSyntaxChecker;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import znaishaded.com.github.fge.jsonschema.core.tree.SchemaTree;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;

public final class URISyntaxChecker
extends AbstractSyntaxChecker {
    public URISyntaxChecker(String keyword) {
        super(keyword, NodeType.STRING, new NodeType[0]);
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        String s2 = this.getNode(tree).textValue();
        try {
            URI uri = new URI(s2);
            if (!uri.equals(uri.normalize())) {
                report.error(this.newMsg(tree, bundle, "common.uri.notNormalized").putArgument("value", s2));
            }
        }
        catch (URISyntaxException ignored) {
            report.error(this.newMsg(tree, bundle, "common.uri.invalid").putArgument("value", s2));
        }
    }
}

