/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.keyword.digest.common;

import java.util.ArrayList;
import java.util.Collections;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.fasterxml.jackson.databind.node.ArrayNode;
import znaishaded.com.fasterxml.jackson.databind.node.ObjectNode;
import znaishaded.com.github.fge.jackson.NodeType;
import znaishaded.com.github.fge.jsonschema.keyword.digest.AbstractDigester;
import znaishaded.com.github.fge.jsonschema.keyword.digest.Digester;
import znaishaded.com.google.common.collect.Lists;

public final class AdditionalPropertiesDigester
extends AbstractDigester {
    private static final Digester INSTANCE = new AdditionalPropertiesDigester();

    public static Digester getInstance() {
        return INSTANCE;
    }

    private AdditionalPropertiesDigester() {
        super("additionalProperties", NodeType.OBJECT, new NodeType[0]);
    }

    @Override
    public JsonNode digest(JsonNode schema) {
        ObjectNode ret = FACTORY.objectNode();
        ArrayNode properties = FACTORY.arrayNode();
        ArrayNode patternProperties = FACTORY.arrayNode();
        ret.put(this.keyword, true);
        ret.set("properties", properties);
        ret.set("patternProperties", patternProperties);
        if (schema.get(this.keyword).asBoolean(true)) {
            return ret;
        }
        ret.put(this.keyword, false);
        ArrayList<String> list = Lists.newArrayList(schema.path("properties").fieldNames());
        Collections.sort(list);
        for (String s2 : list) {
            properties.add(s2);
        }
        list = Lists.newArrayList(schema.path("patternProperties").fieldNames());
        Collections.sort(list);
        for (String s2 : list) {
            patternProperties.add(s2);
        }
        return ret;
    }
}

