/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.keyword.validator.common;

import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.processing.Processor;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import znaishaded.com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import znaishaded.com.github.fge.jsonschema.processors.data.FullData;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;

public final class AdditionalItemsValidator
extends AbstractKeywordValidator {
    private final boolean additionalOK;
    private final int itemsSize;

    public AdditionalItemsValidator(JsonNode digest) {
        super("additionalItems");
        this.additionalOK = digest.get(this.keyword).booleanValue();
        this.itemsSize = digest.get("itemsSize").intValue();
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        if (this.additionalOK) {
            return;
        }
        int size = data.getInstance().getNode().size();
        if (size > this.itemsSize) {
            report.error(this.newMsg(data, bundle, "err.common.additionalItems.notAllowed").putArgument("allowed", this.itemsSize).putArgument("found", size));
        }
    }

    @Override
    public String toString() {
        return this.keyword + ": " + (this.additionalOK ? "allowed" : this.itemsSize + " max");
    }
}

