/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.transform.migrate;

import java.util.Iterator;
import javax.annotation.Nonnull;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.fasterxml.jackson.databind.node.ArrayNode;
import znaishaded.com.fasterxml.jackson.databind.node.ObjectNode;
import znaishaded.com.github.fge.jackson.jsonpointer.JsonPointer;
import znaishaded.io.swagger.transform.migrate.OperationParametersMigrator;
import znaishaded.io.swagger.transform.migrate.SwaggerMigrator;
import znaishaded.io.swagger.transform.util.MutableJsonTree;
import znaishaded.io.swagger.transform.util.SwaggerMigrationException;
import znaishaded.io.swagger.transform.util.SwaggerMigrators;
import znaishaded.io.swagger.util.Json;

public final class ApiObjectMigrator
implements SwaggerMigrator {
    private final SwaggerMigrator parametersMigrator = new OperationParametersMigrator();

    @Override
    @Nonnull
    public JsonNode migrate(@Nonnull JsonNode input) throws SwaggerMigrationException {
        ObjectNode on = (ObjectNode)input;
        if (on.get("type") == null) {
            JsonNode responseMessages = on.get("responseMessages");
            JsonNode type = null;
            if (responseMessages != null && responseMessages instanceof ArrayNode) {
                ArrayNode arrayNode = (ArrayNode)responseMessages;
                Iterator<JsonNode> itr = arrayNode.elements();
                while (itr.hasNext()) {
                    JsonNode rm = itr.next();
                    JsonNode code = rm.get("code");
                    if (code == null || !"200".equals(code.toString())) continue;
                    type = rm;
                }
            }
            if (type != null) {
                if (type.get("type") == null) {
                    on.put("type", "void");
                } else {
                    on.put("type", type.get("type"));
                }
            } else {
                on.put("type", "void");
            }
        }
        if (on.get("parameters") == null) {
            on.put("parameters", Json.mapper().createArrayNode());
        }
        MutableJsonTree tree = new MutableJsonTree(input);
        tree.applyMigrator(SwaggerMigrators.renameMember("httpMethod", "method"));
        tree.applyMigrator(SwaggerMigrators.renameMember("errorResponses", "responseMessages"));
        JsonPointer ptr = JsonPointer.of("responseMessages", new Object[0]);
        if (!ptr.path(tree.getBaseNode()).isMissingNode()) {
            tree.setPointer(ptr);
            tree.applyMigratorToElements(SwaggerMigrators.renameMember("reason", "message"));
        }
        ptr = JsonPointer.of("parameters", new Object[0]);
        tree.setPointer(ptr);
        tree.applyMigratorToElements(this.parametersMigrator);
        return tree.getBaseNode();
    }
}

