/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.handler.impl;

import znaishaded.io.vertx.core.MultiMap;
import znaishaded.io.vertx.core.Vertx;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.file.FileSystem;
import znaishaded.io.vertx.core.http.CaseInsensitiveHeaders;
import znaishaded.io.vertx.core.http.HttpHeaders;
import znaishaded.io.vertx.core.http.HttpServerResponse;
import znaishaded.io.vertx.core.logging.Logger;
import znaishaded.io.vertx.core.logging.LoggerFactory;
import znaishaded.io.vertx.ext.web.RoutingContext;
import znaishaded.io.vertx.ext.web.handler.FaviconHandler;

public class FaviconHandlerImpl
implements FaviconHandler {
    private static final Logger logger = LoggerFactory.getLogger(FaviconHandler.class);
    private static final String DEFAULT_VERTX_ICON = "META-INF/vertx/web/favicon.ico";
    private final Icon NULL_ICON = new Icon();
    private Icon icon;
    private final String path;
    private final long maxAgeSeconds;

    public FaviconHandlerImpl(String path, long maxAgeSeconds) {
        this.path = path;
        this.maxAgeSeconds = maxAgeSeconds;
        if (maxAgeSeconds < 0L) {
            throw new IllegalArgumentException("maxAgeSeconds must be > 0");
        }
    }

    public FaviconHandlerImpl(long maxAgeSeconds) {
        this(null, maxAgeSeconds);
    }

    public FaviconHandlerImpl(String path) {
        this(path, 86400L);
    }

    public FaviconHandlerImpl() {
        this(null);
    }

    private Buffer readFile(FileSystem fs, String path) {
        if (fs.existsBlocking(path)) {
            return fs.readFileBlocking(path);
        }
        throw new RuntimeException(path + " not found!");
    }

    private void init(Vertx vertx) {
        FileSystem fs = vertx.fileSystem();
        Buffer buffer = null;
        if (this.path == null) {
            try {
                buffer = this.readFile(fs, "favicon.ico");
            }
            catch (RuntimeException e) {
                try {
                    buffer = fs.readFileBlocking(DEFAULT_VERTX_ICON);
                }
                catch (RuntimeException runtimeException) {}
            }
        } else {
            try {
                buffer = this.readFile(fs, this.path);
            }
            catch (RuntimeException e) {
                logger.error("Could not load favicon " + this.path);
            }
        }
        this.icon = buffer != null ? new Icon(buffer) : this.NULL_ICON;
    }

    @Override
    public void handle(RoutingContext ctx) {
        if (this.icon == null) {
            this.init(ctx.vertx());
        }
        if ("/favicon.ico".equals(ctx.request().path())) {
            HttpServerResponse resp = ctx.response();
            if (this.icon == this.NULL_ICON) {
                resp.setStatusCode(404).end();
            } else {
                resp.headers().addAll(this.icon.headers);
                resp.end(this.icon.body);
            }
        } else {
            ctx.next();
        }
    }

    private class Icon {
        private final MultiMap headers;
        private final Buffer body;

        private Icon(Buffer buffer) {
            this.headers = new CaseInsensitiveHeaders();
            this.body = buffer;
            this.headers.add(HttpHeaders.CONTENT_TYPE, (CharSequence)"image/x-icon");
            this.headers.add(HttpHeaders.CONTENT_LENGTH, (CharSequence)Integer.toString(buffer.length()));
            this.headers.add(HttpHeaders.CACHE_CONTROL, (CharSequence)("public, max-age=" + FaviconHandlerImpl.this.maxAgeSeconds));
        }

        private Icon() {
            this.headers = null;
            this.body = null;
        }
    }
}

