/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.ugraphic.MinMax;
import znaishaded.net.sourceforge.plantuml.ugraphic.UBackground;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChange;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphicNo;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UShape;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSimple;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;
import znaishaded.net.sourceforge.plantuml.utils.ObjectUtils;

public class CollisionDetector
extends UGraphicNo {
    private final Context context;

    @Override
    public UGraphic apply(UChange change) {
        return new CollisionDetector(this, change);
    }

    private static CollisionDetector create(StringBounder stringBounder) {
        return new CollisionDetector(stringBounder, new UTranslate(), new Context());
    }

    private CollisionDetector(StringBounder stringBounder, UTranslate translate, Context context) {
        super(stringBounder, translate);
        this.context = context;
    }

    private CollisionDetector(CollisionDetector other, UChange change) {
        super(other.getStringBounder(), change instanceof UTranslate ? other.getTranslate().compose((UTranslate)change) : other.getTranslate());
        if (!ObjectUtils.instanceOfAny(change, UBackground.class, HColor.class, UStroke.class, UTranslate.class)) {
            throw new UnsupportedOperationException(change.getClass().toString());
        }
        this.context = other.context;
    }

    private static boolean collisionCheck(MinMax rect, Line2D hline) {
        if (hline.getY1() != hline.getY2()) {
            throw new IllegalArgumentException();
        }
        if (hline.getY1() < rect.getMinY()) {
            return false;
        }
        if (hline.getY1() > rect.getMaxY()) {
            return false;
        }
        double x1 = Math.min(hline.getX1(), hline.getX2());
        double x2 = Math.max(hline.getX1(), hline.getX2());
        if (x2 < rect.getMinX()) {
            return false;
        }
        return !(x1 > rect.getMaxX());
    }

    public void draw(UShape shape) {
        if (shape instanceof UPolygon) {
            this.drawPolygone((UPolygon)shape);
        } else if (shape instanceof URectangle) {
            this.drawRectangle((URectangle)shape);
        } else if (shape instanceof Snake) {
            this.drawSnake((Snake)shape);
        }
    }

    private void drawSnake(Snake shape) {
        if (this.context.manageSnakes) {
            this.context.snakes.add(shape.translate(this.getTranslate()));
        }
    }

    private void drawRectangle(URectangle shape) {
        this.context.rectangles.add(shape.getMinMax().translate(this.getTranslate()));
    }

    private void drawPolygone(UPolygon shape) {
        this.context.rectangles.add(shape.getMinMax().translate(this.getTranslate()));
    }

    public void drawDebug(UGraphic ug) {
        this.context.drawDebug(ug);
    }

    public final void setManageSnakes(boolean manageSnakes) {
        this.context.manageSnakes = manageSnakes;
    }

    static class Context {
        private final List<MinMax> rectangles = new ArrayList<MinMax>();
        private final List<Snake> snakes = new ArrayList<Snake>();
        private boolean manageSnakes;

        Context() {
        }

        public void drawDebug(UGraphic ug) {
            for (MinMax minmax : this.rectangles) {
                if (!this.collision(minmax)) continue;
                minmax.drawGray(ug);
            }
            HColorSimple color = HColorUtils.BLACK;
            ug = ug.apply(color).apply(new UStroke(5.0));
            for (Snake snake : this.snakes) {
                for (Line2D line : snake.getHorizontalLines()) {
                    if (!this.collision(line)) continue;
                    this.drawLine(ug, line);
                }
            }
        }

        private void drawLine(UGraphic ug, Line2D line) {
            ug = ug.apply(new UTranslate(line.getX1(), line.getY1()));
            ug.draw(new ULine(line.getX2() - line.getX1(), line.getY2() - line.getY1()));
        }

        private boolean collision(Line2D hline) {
            for (MinMax r : this.rectangles) {
                if (!CollisionDetector.collisionCheck(r, hline)) continue;
                return true;
            }
            return false;
        }

        private boolean collision(MinMax r) {
            for (Snake snake : this.snakes) {
                for (Line2D hline : snake.getHorizontalLines()) {
                    if (!CollisionDetector.collisionCheck(r, hline)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

