/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile;

import java.util.Set;
import znaishaded.net.sourceforge.plantuml.AlignmentParam;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.LineBreakStrategy;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.PositionedNote;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.AbstractGtile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.creole.Parser;
import znaishaded.net.sourceforge.plantuml.creole.Sheet;
import znaishaded.net.sourceforge.plantuml.creole.SheetBlock1;
import znaishaded.net.sourceforge.plantuml.creole.SheetBlock2;
import znaishaded.net.sourceforge.plantuml.creole.Stencil;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NoteType;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.style.Styleable;
import znaishaded.net.sourceforge.plantuml.svek.image.Opale;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class GtileWithNoteOpale
extends AbstractGtile
implements Stencil,
Styleable {
    private final Gtile tile;
    private final Opale opale;
    private final NotePosition notePosition;
    private final double suppSpace = 20.0;
    private final Swimlane swimlaneNote;
    private final UTranslate positionNote;
    private final UTranslate positionTile;
    private final Dimension2D dimNote;
    private final Dimension2D dimTile;

    @Override
    public StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.note);
    }

    @Override
    public Swimlane getSwimlane(String point) {
        return this.tile.getSwimlane(point);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.tile.getSwimlanes();
    }

    public GtileWithNoteOpale(Gtile tile, PositionedNote note, ISkinParam skinParam, boolean withLink) {
        super(tile.getStringBounder(), tile.skinParam());
        this.swimlaneNote = note.getSwimlaneNote();
        if (note.getColors() != null) {
            skinParam = note.getColors().mute(skinParam);
        }
        this.tile = tile;
        this.notePosition = note.getNotePosition();
        if (note.getType() == NoteType.FLOATING_NOTE) {
            withLink = false;
        }
        Style style = this.getStyleSignature().getMergedStyle(skinParam.getCurrentStyleBuilder()).eventuallyOverride(note.getColors());
        HColor noteBackgroundColor = style.value(PName.BackGroundColor).asColor(skinParam.getThemeStyle(), this.getIHtmlColorSet());
        HColor borderColor = style.value(PName.LineColor).asColor(skinParam.getThemeStyle(), this.getIHtmlColorSet());
        FontConfiguration fc = style.getFontConfiguration(skinParam.getThemeStyle(), this.getIHtmlColorSet());
        double shadowing = style.value(PName.Shadowing).asDouble();
        LineBreakStrategy wrapWidth = style.wrapWidth();
        UStroke stroke = style.getStroke();
        HorizontalAlignment align = skinParam.getHorizontalAlignment(AlignmentParam.noteTextAlignment, null, false, null);
        Sheet sheet = Parser.build(fc, align, skinParam, CreoleMode.FULL).createSheet(note.getDisplay());
        SheetBlock2 text = new SheetBlock2(new SheetBlock1(sheet, wrapWidth, skinParam.getPadding()), this, new UStroke(1.0));
        this.opale = new Opale(shadowing, borderColor, noteBackgroundColor, text, withLink, stroke);
        this.dimNote = this.opale.calculateDimension(this.stringBounder);
        this.dimTile = tile.calculateDimension(this.stringBounder);
        Dimension2D dimTotal = this.calculateDimension(this.stringBounder);
        if (note.getNotePosition() == NotePosition.LEFT) {
            this.positionNote = new UTranslate(0.0, (dimTotal.getHeight() - this.dimNote.getHeight()) / 2.0);
            this.positionTile = new UTranslate(this.dimNote.getWidth() + 20.0, (dimTotal.getHeight() - this.dimTile.getHeight()) / 2.0);
        } else {
            this.positionNote = new UTranslate(this.dimTile.getWidth() + 20.0, (dimTotal.getHeight() - this.dimNote.getHeight()) / 2.0);
            this.positionTile = new UTranslate(0.0, (dimTotal.getHeight() - this.dimTile.getHeight()) / 2.0);
        }
    }

    @Override
    protected UTranslate getCoordImpl(String name) {
        return this.tile.getCoord(name).compose(this.positionTile);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double height = Math.max(this.dimNote.getHeight(), this.dimTile.getHeight());
        return new Dimension2DDouble(this.dimTile.getWidth() + this.dimNote.getWidth() + 20.0, height);
    }

    @Override
    protected void drawUInternal(UGraphic ug) {
        this.opale.drawU(ug.apply(this.positionNote));
        this.tile.drawU(ug.apply(this.positionTile));
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double y) {
        return -this.opale.getMarginX1();
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double y) {
        return this.opale.calculateDimension(stringBounder).getWidth() - (double)this.opale.getMarginX1();
    }
}

