/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile;

import java.util.Collection;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.LineBreakStrategy;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.PositionedNote;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.AbstractGtile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.creole.Parser;
import znaishaded.net.sourceforge.plantuml.creole.Sheet;
import znaishaded.net.sourceforge.plantuml.creole.SheetBlock1;
import znaishaded.net.sourceforge.plantuml.creole.SheetBlock2;
import znaishaded.net.sourceforge.plantuml.creole.Stencil;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.svek.image.Opale;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.utils.MathUtils;

public class GtileWithNotes
extends AbstractGtile {
    private final Gtile tile;
    private TextBlock left;
    private TextBlock right;
    private final double suppSpace = 20.0;

    public StyleSignatureBasic getDefaultStyleDefinition() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.note);
    }

    @Override
    protected UTranslate getCoordImpl(String name) {
        if (name.equals("NORTH_HOOK")) {
            return this.tile.getCoord(name).compose(this.getTranslate(this.getStringBounder()));
        }
        if (name.equals("SOUTH_HOOK")) {
            return this.tile.getCoord(name).compose(this.getTranslate(this.getStringBounder()));
        }
        return super.getCoordImpl(name);
    }

    @Override
    public Swimlane getSwimlane(String point) {
        return this.tile.getSwimlane(point);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.tile.getSwimlanes();
    }

    public GtileWithNotes(Gtile tile, Collection<PositionedNote> notes, ISkinParam skinParam) {
        super(tile.getStringBounder(), tile.skinParam());
        this.tile = tile;
        for (PositionedNote note : notes) {
            ISkinParam skinParam2 = skinParam;
            if (note.getColors() != null) {
                skinParam2 = note.getColors().mute(skinParam2);
            }
            Style style = this.getDefaultStyleDefinition().getMergedStyle(skinParam.getCurrentStyleBuilder()).eventuallyOverride(note.getColors());
            HColor noteBackgroundColor = style.value(PName.BackGroundColor).asColor(skinParam.getThemeStyle(), this.getIHtmlColorSet());
            HColor borderColor = style.value(PName.LineColor).asColor(skinParam.getThemeStyle(), this.getIHtmlColorSet());
            FontConfiguration fc = style.getFontConfiguration(skinParam.getThemeStyle(), this.getIHtmlColorSet());
            double shadowing = style.value(PName.Shadowing).asDouble();
            LineBreakStrategy wrapWidth = style.wrapWidth();
            UStroke stroke = style.getStroke();
            Sheet sheet = Parser.build(fc, skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), skinParam, CreoleMode.FULL).createSheet(note.getDisplay());
            final SheetBlock1 sheet1 = new SheetBlock1(sheet, wrapWidth, skinParam.getPadding());
            SheetBlock2 sheet2 = new SheetBlock2(sheet1, new Stencil(){

                @Override
                public double getStartingX(StringBounder stringBounder, double y) {
                    return -6.0;
                }

                @Override
                public double getEndingX(StringBounder stringBounder, double y) {
                    return sheet1.getEndingX(stringBounder, y) + 15.0;
                }
            }, stroke);
            Opale opale = new Opale(shadowing, borderColor, noteBackgroundColor, sheet2, false, stroke);
            TextBlock opaleMarged = TextBlockUtils.withMargin(opale, 10.0, 10.0);
            if (note.getNotePosition() == NotePosition.LEFT) {
                if (this.left == null) {
                    this.left = opaleMarged;
                    continue;
                }
                this.left = TextBlockUtils.mergeTB(this.left, opaleMarged, HorizontalAlignment.CENTER);
                continue;
            }
            if (this.right == null) {
                this.right = opaleMarged;
                continue;
            }
            this.right = TextBlockUtils.mergeTB(this.right, opaleMarged, HorizontalAlignment.CENTER);
        }
        if (this.left == null) {
            this.left = TextBlockUtils.empty(0.0, 0.0);
        }
        if (this.right == null) {
            this.right = TextBlockUtils.empty(0.0, 0.0);
        }
    }

    private UTranslate getTranslate(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimension(stringBounder);
        Dimension2D dimTile = this.tile.calculateDimension(stringBounder);
        double xDelta = this.left.calculateDimension(stringBounder).getWidth();
        double yDelta = (dimTotal.getHeight() - dimTile.getHeight()) / 2.0;
        return new UTranslate(xDelta, yDelta);
    }

    private UTranslate getTranslateForLeft(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimension(stringBounder);
        Dimension2D dimLeft = this.left.calculateDimension(stringBounder);
        double xDelta = 0.0;
        double yDelta = (dimTotal.getHeight() - dimLeft.getHeight()) / 2.0;
        return new UTranslate(0.0, yDelta);
    }

    private UTranslate getTranslateForRight(StringBounder stringBounder) {
        Dimension2D dimTotal = this.calculateDimension(stringBounder);
        Dimension2D dimRight = this.right.calculateDimension(stringBounder);
        double xDelta = dimTotal.getWidth() - dimRight.getWidth();
        double yDelta = (dimTotal.getHeight() - dimRight.getHeight()) / 2.0;
        return new UTranslate(xDelta, yDelta);
    }

    @Override
    protected void drawUInternal(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        this.left.drawU(ug.apply(this.getTranslateForLeft(stringBounder)));
        this.right.drawU(ug.apply(this.getTranslateForRight(stringBounder)));
        this.tile.drawU(ug.apply(this.getTranslate(stringBounder)));
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimTile = this.tile.calculateDimension(stringBounder);
        Dimension2D dimLeft = this.left.calculateDimension(stringBounder);
        Dimension2D dimRight = this.right.calculateDimension(stringBounder);
        double height = MathUtils.max(dimLeft.getHeight(), dimRight.getHeight(), dimTile.getHeight());
        return new Dimension2DDouble(dimTile.getWidth() + dimLeft.getWidth() + dimRight.getWidth(), height);
    }
}

