/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.braille;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.braille.Coords;
import znaishaded.net.sourceforge.plantuml.posimo.DotPath;

public class BrailleGrid {
    private int minX;
    private int minY;
    private int maxX;
    private int maxY;
    private final double quanta;
    private final Set<Coords> on = new HashSet<Coords>();

    public BrailleGrid(double quanta) {
        this.quanta = quanta;
    }

    public boolean getState(int x, int y) {
        Coords coords = new Coords(x, y);
        return this.on.contains(coords);
    }

    private void setStateDouble(double x, double y, boolean state) {
        this.setState(this.toInt(x), this.toInt(y), state);
    }

    public void setState(int x, int y, boolean state) {
        Coords coords = new Coords(x, y);
        if (state) {
            this.on.add(coords);
        } else {
            this.on.remove(coords);
        }
        this.minX = Math.min(this.minX, x);
        this.maxX = Math.max(this.maxX, x);
        this.minY = Math.min(this.minY, y);
        this.maxY = Math.max(this.maxY, y);
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public void rectangle(double x, double y, double width, double height) {
        this.hline(y, x, x + width);
        this.hline(y + height, x, x + width);
        this.vline(x, y, y + height);
        this.vline(x + width, y, y + height);
    }

    private void vline(double x, double y1, double y2) {
        int i = this.toInt(x);
        int j1 = this.toInt(y1);
        int j2 = this.toInt(y2);
        for (int j = j1; j <= j2; ++j) {
            this.setState(i, j, true);
        }
    }

    private void hline(double y, double x1, double x2) {
        int j = this.toInt(y);
        int i1 = this.toInt(x1);
        int i2 = this.toInt(x2);
        for (int i = i1; i <= i2; ++i) {
            this.setState(i, j, true);
        }
    }

    public int toInt(double value) {
        return (int)Math.round(value / this.quanta);
    }

    public void line(double x1, double y1, double x2, double y2) {
        if (x1 == x2) {
            this.vline(x1, y1, y2);
        } else if (y1 == y2) {
            this.hline(y1, x1, x2);
        } else {
            System.err.println("warning line");
        }
    }

    public double getQuanta() {
        return this.quanta;
    }

    public void drawDotPath(double x, double y, DotPath shape) {
        for (CubicCurve2D.Double bez : shape.getBeziers()) {
            this.drawCubic(x, y, bez);
        }
    }

    private void drawCubic(double x, double y, CubicCurve2D.Double bez) {
        this.drawPointInternal(x, y, bez.getP1());
        this.drawPointInternal(x, y, bez.getP2());
        if (bez.getP1().distance(bez.getP2()) > this.quanta) {
            CubicCurve2D.Double part1 = new CubicCurve2D.Double();
            CubicCurve2D.Double part2 = new CubicCurve2D.Double();
            bez.subdivide(part1, part2);
            this.drawCubic(x, y, part1);
            this.drawCubic(x, y, part2);
        }
    }

    private void drawPointInternal(double x, double y, Point2D pt) {
        this.setStateDouble(x + pt.getX(), y + pt.getY(), true);
    }

    public void drawPolygon(List<Point2D> points) {
        for (int i = 0; i < points.size() - 1; ++i) {
            this.drawLineInternal(points.get(i), points.get(i + 1));
        }
        this.drawLineInternal(points.get(points.size() - 1), points.get(0));
    }

    private void drawLineInternal(Point2D a, Point2D b) {
        this.drawPointInternal(0.0, 0.0, a);
        this.drawPointInternal(0.0, 0.0, b);
        if (a.distance(b) > this.quanta) {
            Point2D.Double middle = new Point2D.Double((a.getX() + b.getX()) / 2.0, (a.getY() + b.getY()) / 2.0);
            this.drawLineInternal(a, middle);
            this.drawLineInternal(middle, b);
        }
    }
}

