/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.classdiagram.command;

import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.UrlMode;
import znaishaded.net.sourceforge.plantuml.classdiagram.ClassDiagram;
import znaishaded.net.sourceforge.plantuml.classdiagram.command.CommandCreateClassMultilines;
import znaishaded.net.sourceforge.plantuml.classdiagram.command.GenericRegexProducer;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOr;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Code;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Ident;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LeafType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotag;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class CommandCreateClass
extends SingleLineCommand2<ClassDiagram> {
    public static final String DISPLAY_WITH_GENERIC = "[%g](.+?)(?:\\<(" + GenericRegexProducer.PATTERN + ")\\>)?[%g]";
    public static final String CODE = "[^%s{}%g<>]+";
    public static final String CODE_NO_DOTDOT = "[^%s{}%g<>:]+";

    public CommandCreateClass() {
        super(CommandCreateClass.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandCreateClass.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "(interface|enum|annotation|abstract[%s]+class|abstract|class|entity|circle|diamond|protocol|struct)"), RegexLeaf.spaceOneOrMore(), new RegexOr(new RegexConcat(new RegexLeaf("DISPLAY1", DISPLAY_WITH_GENERIC), RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE1", "([^%s{}%g<>]+)")), new RegexConcat(new RegexLeaf("CODE2", "([^%s{}%g<>]+)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("DISPLAY2", DISPLAY_WITH_GENERIC)), new RegexLeaf("CODE3", "([^%s{}%g<>]+)"), new RegexLeaf("CODE4", "[%g]([^%g]+)[%g]")), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceZeroOrMore(), new RegexLeaf("GENERIC", "\\<(" + GenericRegexProducer.PATTERN + ")\\>"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<{2}.*\\>{2})?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.spaceZeroOrMore(), CommandCreateClass.color().getRegex(), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf("##"), new RegexLeaf("LINECOLOR", "(?:\\[(dotted|dashed|bold)\\])?(\\w+)?"))), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("EXTENDS", "(extends)[%s]+(" + CommandCreateClassMultilines.CODES + ")"))), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("IMPLEMENTS", "(implements)[%s]+(" + CommandCreateClassMultilines.CODES + ")"))), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\{"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\}"))), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeArg(ClassDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        HColor lineColor;
        String urlString;
        ILeaf entity;
        LeafType type = LeafType.getLeafType(StringUtils.goUpperCase(arg.get("TYPE", 0)));
        String idShort = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.getLazzy("CODE", 0), "\"([:");
        String display = arg.getLazzy("DISPLAY", 0);
        String genericOption = arg.getLazzy("DISPLAY", 1);
        String generic = genericOption != null ? genericOption : arg.get("GENERIC", 0);
        String stereo = arg.get("STEREO", 0);
        Ident idNewLong = diagram.buildLeafIdent(idShort);
        if (diagram.V1972()) {
            if (diagram.leafExistSmart(idNewLong)) {
                entity = diagram.getOrCreateLeaf(idNewLong, idNewLong, type, null);
                if (!entity.muteToType(type, null)) {
                    return CommandExecutionResult.error("Bad name");
                }
            } else {
                entity = diagram.createLeaf(idNewLong, idNewLong, Display.getWithNewlines(display), type, null);
            }
        } else {
            Code code = diagram.buildCode(idShort);
            if (diagram.leafExist(code)) {
                entity = diagram.getOrCreateLeaf(idNewLong, code, type, null);
                if (!entity.muteToType(type, null)) {
                    return CommandExecutionResult.error("Bad name");
                }
            } else {
                entity = diagram.createLeaf(idNewLong, code, Display.getWithNewlines(display), type, null);
            }
        }
        if (stereo != null) {
            entity.setStereotype(Stereotype.build(stereo, diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
            entity.setStereostyle(stereo);
        }
        if (generic != null) {
            entity.setGeneric(generic);
        }
        if ((urlString = arg.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            entity.addUrl(url);
        }
        entity.setCodeLine(location);
        Colors colors = CommandCreateClass.color().getColor(diagram.getSkinParam().getThemeStyle(), arg, diagram.getSkinParam().getIHtmlColorSet());
        String s2 = arg.get("LINECOLOR", 1);
        HColor hColor = lineColor = s2 == null ? null : diagram.getSkinParam().getIHtmlColorSet().getColor(diagram.getSkinParam().getThemeStyle(), s2);
        if (lineColor != null) {
            colors = colors.add(ColorType.LINE, lineColor);
        }
        if (arg.get("LINECOLOR", 0) != null) {
            colors = colors.addLegacyStroke(arg.get("LINECOLOR", 0));
        }
        entity.setColors(colors);
        CommandCreateClassMultilines.manageExtends("EXTENDS", diagram, arg, entity);
        CommandCreateClassMultilines.manageExtends("IMPLEMENTS", diagram, arg, entity);
        CommandCreateClassMultilines.addTags(entity, arg.get("TAGS", 0));
        return CommandExecutionResult.ok();
    }

    static enum Mode {
        EXTENDS,
        IMPLEMENTS;

    }
}

