/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command.note.sequence;

import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.UrlMode;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.Command;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines2;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Note;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NoteStyle;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Participant;
import znaishaded.net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public final class FactorySequenceNoteAcrossCommand
implements SingleMultiFactoryCommand<SequenceDiagram> {
    private IRegex getRegexConcatMultiLine() {
        return RegexConcat.build(FactorySequenceNoteAcrossCommand.class.getName() + "multi", RegexLeaf.start(), new RegexLeaf("VMERGE", "(/)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STYLE", "(note|hnote|rnote)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<{2}.*\\>{2})?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("ACROSS", "(accross|across)"), RegexLeaf.spaceZeroOrMore(), FactorySequenceNoteAcrossCommand.color().getRegex(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.end());
    }

    private IRegex getRegexConcatSingleLine() {
        return RegexConcat.build(FactorySequenceNoteAcrossCommand.class.getName() + "single", RegexLeaf.start(), new RegexLeaf("VMERGE", "(/)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STYLE", "(note|hnote|rnote)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<{2}.*\\>{2})?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("ACROSS", "(accross|across)"), RegexLeaf.spaceZeroOrMore(), FactorySequenceNoteAcrossCommand.color().getRegex(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("NOTE", "(.*)"), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    public Command<SequenceDiagram> createSingleLine() {
        return new SingleLineCommand2<SequenceDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(SequenceDiagram system, LineLocation location, RegexResult arg) throws NoSuchColorException {
                BlocLines strings = BlocLines.getWithNewlines(arg.get("NOTE", 0));
                return FactorySequenceNoteAcrossCommand.this.executeInternal(system, arg, strings);
            }
        };
    }

    @Override
    public Command<SequenceDiagram> createMultiLine(boolean withBracket) {
        return new CommandMultilines2<SequenceDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.KEEP_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                return "^end[%s]?(note|hnote|rnote)$";
            }

            @Override
            protected CommandExecutionResult executeNow(SequenceDiagram system, BlocLines lines) throws NoSuchColorException {
                RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
                lines = lines.subExtract(1, 1);
                lines = lines.removeEmptyColumns();
                return FactorySequenceNoteAcrossCommand.this.executeInternal(system, line0, lines);
            }
        };
    }

    private CommandExecutionResult executeInternal(SequenceDiagram diagram, RegexResult line0, BlocLines lines) throws NoSuchColorException {
        String across = line0.get("ACROSS", 0);
        if (across.equalsIgnoreCase("accross")) {
            return CommandExecutionResult.error("Use 'across' instead of 'accross'");
        }
        if (lines.size() > 0) {
            boolean tryMerge = line0.get("VMERGE", 0) != null;
            Display display = diagram.manageVariable(lines.toDisplay());
            Note note = new Note((Participant)null, (Participant)null, display, diagram.getSkinParam().getCurrentStyleBuilder());
            Colors colors = FactorySequenceNoteAcrossCommand.color().getColor(diagram.getSkinParam().getThemeStyle(), line0, diagram.getSkinParam().getIHtmlColorSet());
            String stereotypeString = line0.get("STEREO", 0);
            if (stereotypeString != null) {
                Stereotype stereotype = Stereotype.build(stereotypeString);
                colors = colors.applyStereotypeForNote(stereotype, diagram.getSkinParam(), ColorParam.noteBackground, ColorParam.noteBorder);
                note.setStereotype(stereotype);
            }
            note.setColors(colors);
            note.setNoteStyle(NoteStyle.getNoteStyle(line0.get("STYLE", 0)));
            if (line0.get("URL", 0) != null) {
                UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
                Url urlLink = urlBuilder.getUrl(line0.get("URL", 0));
                note.setUrl(urlLink);
            }
            diagram.addNote(note, tryMerge);
        }
        return CommandExecutionResult.ok();
    }
}

