/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.descdiagram.command;

import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOr;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Ident;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LeafType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import znaishaded.net.sourceforge.plantuml.graphic.USymbols;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class CommandArchimate
extends SingleLineCommand2<DescriptionDiagram> {
    public CommandArchimate() {
        super(CommandArchimate.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandArchimate.class.getName(), RegexLeaf.start(), new RegexLeaf("SYMBOL", "archimate"), RegexLeaf.spaceOneOrMore(), CommandArchimate.color().getRegex(), RegexLeaf.spaceOneOrMore(), new RegexOr(new RegexLeaf("CODE1", "([%pLN_.]+|\\(\\)[%s]*[%pLN_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\]|[%g].+?[%g])"), new RegexConcat(new RegexLeaf("DISPLAY2", "([%g].+?[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\])"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("STEREOTYPE2", "(?:\\<\\<([-\\w]+)\\>\\>)"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE2", "([%pLN_.]+|\\(\\)[%s]*[%pLN_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\])")), new RegexConcat(new RegexLeaf("CODE3", "([%pLN_.]+|\\(\\)[%s]*[%pLN_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\])"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("STEREOTYPE3", "(?:\\<\\<([-\\w]+)\\>\\>)"))), RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("DISPLAY3", "([%g].+?[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\])")), new RegexConcat(new RegexLeaf("DISPLAY4", "([%g].+?[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\]|[%pLN_.]+)"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("STEREOTYPE4", "(?:\\<\\<([-\\w]+)\\>\\>)"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE4", "([%pLN_.]+|\\(\\)[%s]*[%pLN_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\])"))), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREOTYPE", "(?:\\<\\<([-\\w]+)\\>\\>)"))), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeArg(DescriptionDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        String codeRaw = arg.getLazzy("CODE", 0);
        String idShort = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(codeRaw);
        Ident ident = diagram.buildLeafIdent(idShort);
        Ident code = diagram.V1972() ? ident : diagram.buildCode(idShort);
        String icon = arg.getLazzy("STEREOTYPE", 0);
        ILeaf entity = diagram.getOrCreateLeaf(ident, code, LeafType.DESCRIPTION, USymbols.ARCHIMATE);
        String displayRaw = arg.getLazzy("DISPLAY", 0);
        String display = displayRaw;
        if (display == null) {
            display = code.getName();
        }
        display = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(display);
        entity.setDisplay(Display.getWithNewlines(display));
        entity.setUSymbol(USymbols.ARCHIMATE);
        if (icon != null) {
            entity.setStereotype(Stereotype.build("<<$archimate/" + icon + ">>", diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        }
        Colors colors = CommandArchimate.color().getColor(diagram.getSkinParam().getThemeStyle(), arg, diagram.getSkinParam().getIHtmlColorSet());
        entity.setColors(colors);
        return CommandExecutionResult.ok();
    }
}

