/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.descdiagram.command;

import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.UrlMode;
import znaishaded.net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import znaishaded.net.sourceforge.plantuml.classdiagram.command.CommandCreateClassMultilines;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOr;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.GroupType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IGroup;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Ident;
import znaishaded.net.sourceforge.plantuml.cucadiagram.NamespaceStrategy;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotag;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.USymbols;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.utils.UniqueSequence;

public class CommandPackageWithUSymbol
extends SingleLineCommand2<AbstractEntityDiagram> {
    public CommandPackageWithUSymbol() {
        super(CommandPackageWithUSymbol.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandPackageWithUSymbol.class.getName(), RegexLeaf.start(), new RegexLeaf("SYMBOL", "(package|rectangle|hexagon|node|artifact|folder|file|frame|cloud|database|storage|component|card|together|queue|stack)"), RegexLeaf.spaceOneOrMore(), new RegexOr(new RegexConcat(new RegexLeaf("DISPLAY1", "([%g].+?[%g])"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("STEREOTYPE1", "(\\<\\<.+\\>\\>)"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE1", "([^#%s{}]+)")), new RegexConcat(new RegexLeaf("CODE2", "([^#%s{}%g]+)"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("STEREOTYPE2", "(\\<\\<.+\\>\\>)"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("DISPLAY2", "([%g].+?[%g])")), new RegexConcat(new RegexLeaf("DISPLAY3", "([^#%s{}%g]+)"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("STEREOTYPE3", "(\\<\\<.+\\>\\>)"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE3", "([^#%s{}%g]+)")), new RegexLeaf("CODE8", "([%g][^%g]+[%g])"), new RegexLeaf("CODE9", "([^#%s{}%g]*)")), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.spaceZeroOrMore(), CommandPackageWithUSymbol.color().getRegex(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\{"), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractEntityDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        String urlString;
        String display;
        String idShort;
        String codeRaw = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.getLazzy("CODE", 0));
        String displayRaw = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.getLazzy("DISPLAY", 0));
        if (codeRaw.length() == 0) {
            idShort = UniqueSequence.getString("##");
            display = null;
        } else {
            idShort = codeRaw;
            display = displayRaw == null ? idShort : displayRaw;
        }
        Ident ident = diagram.buildLeafIdent(idShort);
        Ident code = diagram.V1972() ? ident : diagram.buildCode(idShort);
        IGroup currentPackage = diagram.getCurrentGroup();
        diagram.gotoGroup(ident, code, Display.getWithNewlines(display), GroupType.PACKAGE, currentPackage, NamespaceStrategy.SINGLE);
        IGroup p = diagram.getCurrentGroup();
        String symbol = arg.get("SYMBOL", 0);
        if ("together".equalsIgnoreCase(symbol)) {
            p.setThisIsTogether();
        }
        p.setUSymbol(USymbols.fromString(symbol, diagram.getSkinParam().actorStyle(), diagram.getSkinParam().componentStyle(), diagram.getSkinParam().packageStyle()));
        String stereotype = arg.getLazzy("STEREOTYPE", 0);
        if (stereotype != null) {
            p.setStereotype(Stereotype.build(stereotype, false));
        }
        if ((urlString = arg.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            p.addUrl(url);
        }
        CommandCreateClassMultilines.addTags(p, arg.get("TAGS", 0));
        Colors colors = CommandPackageWithUSymbol.color().getColor(diagram.getSkinParam().getThemeStyle(), arg, diagram.getSkinParam().getIHtmlColorSet());
        p.setColors(colors);
        return CommandExecutionResult.ok();
    }
}

