/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.nwdiag;

import java.util.Set;
import znaishaded.net.sourceforge.plantuml.graphic.UDrawable;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPath;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorNone;

public class VerticalLine
implements UDrawable {
    private final double y1;
    private final double y2;
    private final Set<Double> skip;

    public VerticalLine(double y1, double y2, Set<Double> skip) {
        this.y1 = Math.min(y1, y2);
        this.y2 = Math.max(y1, y2);
        this.skip = skip;
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = ug.apply(new HColorNone().bg());
        boolean drawn = false;
        double current = this.y1;
        UPath path = new UPath();
        path.moveTo(0.0, current);
        for (Double step : this.skip) {
            if (step < this.y1) continue;
            assert (step >= this.y1);
            drawn = true;
            if (step == this.y2) {
                path.lineTo(0.0, this.y2);
            } else {
                path.lineTo(0.0, Math.min(this.y2, step - 3.0));
                if (this.y2 > step) {
                    path.arcTo(4.0, 4.0, 0.0, 0.0, 1.0, 0.0, step + 9.0);
                    continue;
                }
            }
            ug.draw(path);
            path = new UPath();
            current = step + 9.0;
            path.moveTo(0.0, current);
            if (!(current >= this.y2)) continue;
            break;
        }
        if (!drawn) {
            path.lineTo(0.0, this.y2);
            ug.draw(path);
        }
    }
}

