/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.objectdiagram.command;

import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.StringLocated;
import znaishaded.net.sourceforge.plantuml.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.CommandControl;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines2;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.BodierJSon;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IEntity;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Ident;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LeafType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.json.Json;
import znaishaded.net.sourceforge.plantuml.json.JsonParser;
import znaishaded.net.sourceforge.plantuml.json.JsonValue;
import znaishaded.net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class CommandCreateJson
extends CommandMultilines2<AbstractClassOrObjectDiagram> {
    public CommandCreateJson() {
        super(CommandCreateJson.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandCreateJson.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "json"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("NAME", "(?:[%g]([^%g]+)[%g][%s]+as[%s]+)?([%pLN_.]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<\\<.+\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\{"), RegexLeaf.end());
    }

    @Override
    public String getPatternEnd() {
        return "^[%s]*\\}[%s]*$";
    }

    @Override
    protected CommandExecutionResult executeNow(AbstractClassOrObjectDiagram diagram, BlocLines lines) throws NoSuchColorException {
        lines = lines.trim().removeEmptyLines();
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        IEntity entity1 = this.executeArg0(diagram, line0);
        if (entity1 == null) {
            return CommandExecutionResult.error("No such entity");
        }
        JsonValue json = this.getJsonValue(lines);
        if (json == null) {
            return CommandExecutionResult.error("Bad data");
        }
        ((BodierJSon)entity1.getBodier()).setJson(json);
        return CommandExecutionResult.ok();
    }

    @Override
    protected CommandControl finalVerification(BlocLines lines) {
        JsonValue json = this.getJsonValue(lines);
        if (json == null) {
            return CommandControl.OK_PARTIAL;
        }
        return super.finalVerification(lines);
    }

    private JsonValue getJsonValue(BlocLines lines) {
        try {
            String sb = this.getJsonString(lines);
            Json.DefaultHandler handler = new Json.DefaultHandler();
            new JsonParser(handler).parse(sb);
            JsonValue json = handler.getValue();
            return json;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getJsonString(BlocLines lines) {
        lines = lines.subExtract(1, 1);
        StringBuilder sb = new StringBuilder("{");
        for (StringLocated sl : lines) {
            String line = sl.getString();
            assert (line.length() > 0);
            sb.append(line);
        }
        sb.append("}");
        return sb.toString();
    }

    private IEntity executeArg0(AbstractClassOrObjectDiagram diagram, RegexResult line0) throws NoSuchColorException {
        String s2;
        boolean leafExist;
        String name = line0.get("NAME", 1);
        Ident ident = diagram.buildLeafIdent(name);
        Ident code = diagram.V1972() ? ident : diagram.buildCode(name);
        String display = line0.get("NAME", 0);
        String stereotype = line0.get("STEREO", 0);
        boolean bl = leafExist = diagram.V1972() ? diagram.leafExistSmart(ident) : diagram.leafExist(code);
        if (leafExist) {
            return diagram.getOrCreateLeaf(diagram.buildLeafIdent(name), code, LeafType.JSON, null);
        }
        ILeaf entity = diagram.createLeaf(ident, code, Display.getWithNewlines(display), LeafType.JSON, null);
        if (stereotype != null) {
            entity.setStereotype(Stereotype.build(stereotype, diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        }
        entity.setSpecificColorTOBEREMOVED(ColorType.BACK, (s2 = line0.get("COLOR", 0)) == null ? null : diagram.getSkinParam().getIHtmlColorSet().getColor(diagram.getSkinParam().getThemeStyle(), s2));
        return entity;
    }
}

