/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.oregon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import znaishaded.net.sourceforge.plantuml.Log;

public class MagicTable {
    private final Oc[] number = new Oc[10000];
    private static ArrayList<int[]> neighbours = new ArrayList();

    public static int[] getNeighbours(int nb) {
        if (neighbours.get(nb) == null) {
            neighbours.set(nb, MagicTable.getNeighboursSlow(nb));
        }
        return neighbours.get(nb);
    }

    public static int[] getNeighboursSlow(int nb) {
        int[] result = new int[36];
        int v1 = nb % 10;
        int root = nb - v1;
        int cpt = 0;
        for (int i = 0; i < 10; ++i) {
            int candidate = root + i;
            if (candidate == nb) continue;
            result[cpt++] = candidate;
        }
        int v2 = nb / 10 % 10;
        root = nb - v2 * 10;
        for (int i = 0; i < 10; ++i) {
            int candidate = root + i * 10;
            if (candidate == nb) continue;
            result[cpt++] = candidate;
        }
        int v3 = nb / 100 % 10;
        root = nb - v3 * 100;
        for (int i = 0; i < 10; ++i) {
            int candidate = root + i * 100;
            if (candidate == nb) continue;
            result[cpt++] = candidate;
        }
        int v4 = nb / 1000;
        root = nb - v4 * 1000;
        for (int i = 0; i < 10; ++i) {
            int candidate = root + i * 1000;
            if (candidate == nb) continue;
            result[cpt++] = candidate;
        }
        return result;
    }

    public List<Integer> getAllFree() {
        ArrayList<Integer> result = new ArrayList<Integer>(10000);
        for (int i = 0; i < this.number.length; ++i) {
            if (this.number[i] != null) continue;
            result.add(i);
        }
        return result;
    }

    public List<Integer> getAllUsed() {
        ArrayList<Integer> result = new ArrayList<Integer>(10000);
        for (int i = 0; i < this.number.length; ++i) {
            if (this.number[i] != Oc.USED) continue;
            result.add(i);
        }
        return result;
    }

    public boolean isUsuable(int nb) {
        if (this.number[nb] != null) {
            return false;
        }
        for (int near : MagicTable.getNeighbours(nb)) {
            if (this.number[near] == null) continue;
            return false;
        }
        return true;
    }

    public void burnNumber(int nb) {
        if (this.number[nb] != null) {
            throw new IllegalArgumentException();
        }
        this.number[nb] = Oc.USED;
        for (int near : MagicTable.getNeighbours(nb)) {
            this.number[near] = Oc.NEAR;
        }
    }

    public int getRandomFree(Random rnd) {
        List<Integer> frees = this.getAllFree();
        Collections.shuffle(frees, rnd);
        for (int nb : frees) {
            if (!this.isUsuable(nb)) continue;
            return nb;
        }
        return -1;
    }

    public static int size(Random rnd, MagicTable mt) {
        int candidate;
        int i = 0;
        while ((candidate = mt.getRandomFree(rnd)) != -1) {
            mt.burnNumber(candidate);
            ++i;
        }
        return i;
    }

    public static void main(String[] args) {
        int max = 0;
        long start = System.currentTimeMillis();
        Random rnd = new Random(49L);
        int nb = 200000;
        for (int i = 0; i < 200000; ++i) {
            MagicTable mt;
            int v;
            if (i == 100) {
                long dur = (System.currentTimeMillis() - start) / 1000L;
                dur = dur * 200000L / 100L;
                Log.println("Estimated duration = " + (dur /= 3600L) + " h");
            }
            if ((v = MagicTable.size(rnd, mt = new MagicTable())) <= max) continue;
            Log.println("v=" + v);
            Log.println("mt=" + mt.getAllUsed());
            max = v;
        }
        long duration = System.currentTimeMillis() - start;
        Log.println("Duration = " + duration / 1000L / 60L);
    }

    public static void main2(String[] args) {
        int max = 0;
        long start = System.currentTimeMillis();
        for (int j = 1; j < 100; ++j) {
            Random rnd = new Random(j);
            for (int i = 0; i < 1000; ++i) {
                MagicTable mt = new MagicTable();
                int v = MagicTable.size(rnd, mt);
                if (v <= max) continue;
                Log.println("v=" + v);
                Log.println("mt=" + mt.getAllUsed());
                max = v;
            }
        }
        long duration = System.currentTimeMillis() - start;
        Log.println("Duration = " + duration / 1000L / 60L);
    }

    static {
        for (int i = 0; i < 10000; ++i) {
            neighbours.add(null);
        }
    }

    static enum Oc {
        USED,
        NEAR;

    }
}

