/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.png;

import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.png.PngIOMetadata;
import znaishaded.net.sourceforge.plantuml.security.SFile;
import znaishaded.net.sourceforge.plantuml.security.SImageIO;

public class PngIO {
    private static final String copyleft = "Generated by http://plantuml.com";

    public static void write(RenderedImage image, SFile file, int dpi) throws IOException {
        PngIO.write(image, file, null, dpi);
    }

    public static void write(RenderedImage image, OutputStream os, int dpi) throws IOException {
        PngIO.write(image, os, null, dpi);
    }

    public static void write(RenderedImage image, SFile file, String metadata, int dpi) throws IOException {
        try (BufferedOutputStream os = file.createBufferedOutputStream();){
            PngIO.write(image, os, metadata, dpi);
        }
        Log.debug("File is " + file);
        Log.debug("File size " + file.length());
        if (file.length() == 0L) {
            Log.error("File size is zero: " + file);
            SImageIO.write(image, "png", file);
        }
    }

    public static void write(RenderedImage image, OutputStream os, String metadata, int dpi) throws IOException {
        PngIO.write(image, os, metadata, dpi, null);
    }

    public static void write(RenderedImage image, OutputStream os, String metadata, int dpi, String debugData) throws IOException {
        if (metadata == null) {
            SImageIO.write(image, "png", os);
        } else {
            PngIOMetadata.writeWithMetadata(image, os, metadata, dpi, debugData);
        }
    }
}

