/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.command;

import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.project.GanttConstraint;
import znaishaded.net.sourceforge.plantuml.project.GanttDiagram;
import znaishaded.net.sourceforge.plantuml.project.core.Task;

public class CommandGanttArrow
extends SingleLineCommand2<GanttDiagram> {
    public CommandGanttArrow() {
        super(CommandGanttArrow.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandGanttArrow.class.getName(), RegexLeaf.start(), new RegexLeaf("CODE1", "([%pLN_.]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("(-+)"), new RegexLeaf("ARROW_STYLE", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)\\])?"), new RegexLeaf("(-*)"), new RegexLeaf("\\>"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("CODE2", "([%pLN_.]+)"), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(GanttDiagram diagram, LineLocation location, RegexResult arg) {
        String code1 = arg.get("CODE1", 0);
        String code2 = arg.get("CODE2", 0);
        Task task1 = diagram.getExistingTask(code1);
        if (task1 == null) {
            return CommandExecutionResult.error("No such task " + code1);
        }
        Task task2 = diagram.getExistingTask(code2);
        if (task2 == null) {
            return CommandExecutionResult.error("No such task " + code2);
        }
        GanttConstraint link = diagram.forceTaskOrder(task1, task2);
        link.applyStyle(diagram.getSkinParam().getThemeStyle(), arg.get("ARROW_STYLE", 0));
        return CommandExecutionResult.ok();
    }
}

