/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.command;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.sequencediagram.GroupingType;
import znaishaded.net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSet;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class CommandGrouping
extends SingleLineCommand2<SequenceDiagram> {
    public CommandGrouping() {
        super(CommandGrouping.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandGrouping.class.getName(), RegexLeaf.start(), new RegexLeaf("PARALLEL", "(&[%s]*)?"), new RegexLeaf("TYPE", "(opt|alt|loop|par|par2|break|critical|else|end|also|group)"), new RegexLeaf("COLORS", "((?<!else)(?<!also)(?<!end)#\\w+)?(?:[%s]+(#\\w+))?"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("COMMENT", "(.*?)"))), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        boolean parallel;
        boolean result;
        String type = StringUtils.goLowerCase(arg.get("TYPE", 0));
        String s2 = arg.get("COLORS", 0);
        HColorSet colorSet = diagram.getSkinParam().getIHtmlColorSet();
        HColor backColorElement = null;
        if (s2 != null) {
            backColorElement = colorSet.getColor(diagram.getSkinParam().getThemeStyle(), s2, null);
        }
        String s22 = arg.get("COLORS", 1);
        HColor backColorGeneral = null;
        if (s22 != null) {
            backColorGeneral = colorSet.getColor(diagram.getSkinParam().getThemeStyle(), s22, diagram.getSkinParam().getBackgroundColor());
        }
        String comment = arg.get("COMMENT", 0);
        GroupingType groupingType = GroupingType.getType(type);
        if ("group".equals(type)) {
            if (StringUtils.isEmpty(comment)) {
                comment = "group";
            } else {
                Pattern p = Pattern.compile("^(.*\\[\\[.*\\]\\].*?|.*?)\\[(.*)\\]$");
                Matcher m3 = p.matcher(comment);
                if (m3.find()) {
                    type = m3.group(1);
                    comment = m3.group(2);
                }
            }
        }
        if (!(result = diagram.grouping(type, comment, groupingType, backColorGeneral, backColorElement, parallel = arg.get("PARALLEL", 0) != null))) {
            return CommandExecutionResult.error("Cannot create group");
        }
        return CommandExecutionResult.ok();
    }
}

