/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.skin;

import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.LineBreakStrategy;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.cucadiagram.BodyFactory;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockEmpty;
import znaishaded.net.sourceforge.plantuml.skin.AbstractComponent;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSet;

public abstract class AbstractTextualComponent
extends AbstractComponent {
    private final int marginX1;
    private final int marginX2;
    private final int marginY;
    private final TextBlock textBlock;
    private final ISkinSimple spriteContainer;
    private final UFont font;
    private final HColor fontColor;
    private final HorizontalAlignment alignment;

    public AbstractTextualComponent(Style style, LineBreakStrategy maxMessageSize, int marginX1, int marginX2, int marginY, ISkinSimple spriteContainer, CharSequence label) {
        this(style, style, maxMessageSize, marginX1, marginX2, marginY, spriteContainer, Display.getWithNewlines(label == null ? "" : label.toString()), false);
    }

    public AbstractTextualComponent(Style style, LineBreakStrategy maxMessageSize, int marginX1, int marginX2, int marginY, ISkinSimple spriteContainer, Display display, boolean enhanced) {
        this(style, style, maxMessageSize, marginX1, marginX2, marginY, spriteContainer, display, enhanced);
    }

    public AbstractTextualComponent(Style style, Style stereo, LineBreakStrategy maxMessageSize, int marginX1, int marginX2, int marginY, ISkinSimple spriteContainer, Display display, boolean enhanced) {
        super(style);
        this.spriteContainer = spriteContainer;
        FontConfiguration fc = style.getFontConfiguration(spriteContainer.getThemeStyle(), this.getIHtmlColorSet());
        this.font = style.getUFont();
        this.fontColor = style.value(PName.FontColor).asColor(spriteContainer.getThemeStyle(), this.getIHtmlColorSet());
        HorizontalAlignment horizontalAlignment = style.getHorizontalAlignment();
        UFont fontForStereotype = stereo.getUFont();
        HColor htmlColorForStereotype = stereo.value(PName.FontColor).asColor(spriteContainer.getThemeStyle(), this.getIHtmlColorSet());
        display = display.withoutStereotypeIfNeeded(style);
        this.marginX1 = marginX1;
        this.marginX2 = marginX2;
        this.marginY = marginY;
        this.textBlock = display.size() == 1 && display.get(0).length() == 0 ? new TextBlockEmpty() : (enhanced ? BodyFactory.create3(display, spriteContainer, horizontalAlignment, fc, maxMessageSize, style) : display.create0(fc, horizontalAlignment, spriteContainer, maxMessageSize, CreoleMode.FULL, fontForStereotype, htmlColorForStereotype, marginX1, marginX2));
        this.alignment = horizontalAlignment;
    }

    protected HColorSet getIHtmlColorSet() {
        return ((ISkinParam)this.spriteContainer).getIHtmlColorSet();
    }

    protected TextBlock getTextBlock() {
        return this.textBlock;
    }

    protected double getPureTextWidth(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        Dimension2D size = textBlock.calculateDimension(stringBounder);
        return size.getWidth();
    }

    public final double getTextWidth(StringBounder stringBounder) {
        return this.getPureTextWidth(stringBounder) + (double)this.marginX1 + (double)this.marginX2;
    }

    protected final double getTextHeight(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        Dimension2D size = textBlock.calculateDimension(stringBounder);
        return size.getHeight() + (double)(2 * this.marginY);
    }

    protected final int getMarginX1() {
        return this.marginX1;
    }

    protected final int getMarginX2() {
        return this.marginX2;
    }

    protected final int getMarginY() {
        return this.marginY;
    }

    protected final UFont getFont() {
        return this.font;
    }

    protected HColor getFontColor() {
        return this.fontColor;
    }

    protected final ISkinSimple getISkinSimple() {
        return this.spriteContainer;
    }

    public final HorizontalAlignment getHorizontalAlignment() {
        return this.alignment;
    }
}

