/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.skin.rose;

import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.creole.Stencil;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.SymbolContext;
import znaishaded.net.sourceforge.plantuml.skin.AbstractTextualComponent;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.svek.image.Opale;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPath;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public final class ComponentRoseNote
extends AbstractTextualComponent
implements Stencil {
    private final double paddingX;
    private final double paddingY;
    private final SymbolContext symbolContext;
    private final double roundCorner;
    private final HorizontalAlignment position;

    public ComponentRoseNote(Style style, Display strings, double paddingX, double paddingY, ISkinSimple spriteContainer, HorizontalAlignment textAlignment, HorizontalAlignment position) {
        super(style, spriteContainer.wrapWidth(), textAlignment == HorizontalAlignment.CENTER ? 15 : 6, 15, 5, spriteContainer, strings, true);
        this.paddingX = paddingX;
        this.paddingY = paddingY;
        this.position = position;
        this.symbolContext = style.getSymbolContext(spriteContainer.getThemeStyle(), this.getIHtmlColorSet());
        this.roundCorner = style.value(PName.RoundCorner).asInt();
    }

    @Override
    public final double getPreferredWidth(StringBounder stringBounder) {
        double result = this.getTextWidth(stringBounder) + 2.0 * this.getPaddingX() + this.symbolContext.getDeltaShadow();
        return result;
    }

    @Override
    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 2.0 * this.getPaddingY() + this.symbolContext.getDeltaShadow();
    }

    @Override
    public double getPaddingX() {
        return this.paddingX;
    }

    @Override
    public double getPaddingY() {
        return this.paddingY;
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        StringBounder stringBounder = ug.getStringBounder();
        int textHeight = (int)this.getTextHeight(stringBounder);
        int x2 = (int)this.getTextWidth(stringBounder);
        double diffX = area.getDimensionToUse().getWidth() - this.getPreferredWidth(stringBounder);
        if (diffX < 0.0) {
            throw new IllegalArgumentException();
        }
        if (area.getDimensionToUse().getWidth() > this.getPreferredWidth(stringBounder)) {
            x2 = (int)(area.getDimensionToUse().getWidth() - 2.0 * this.getPaddingX());
        }
        UPath polygon = Opale.getPolygonNormal(x2, textHeight, this.roundCorner);
        polygon.setDeltaShadow(this.symbolContext.getDeltaShadow());
        ug = this.symbolContext.apply(ug);
        ug.draw(polygon);
        ug.draw(Opale.getCorner(x2, this.roundCorner));
        UGraphic ug2 = UGraphicStencil.create(ug, this, new UStroke());
        ug2 = this.position == HorizontalAlignment.LEFT ? ug2.apply(new UTranslate(this.getMarginX1(), this.getMarginY())) : (this.position == HorizontalAlignment.RIGHT ? ug2.apply(new UTranslate(area.getDimensionToUse().getWidth() - this.getTextWidth(stringBounder), this.getMarginY())) : ug2.apply(new UTranslate((double)this.getMarginX1() + diffX / 2.0, this.getMarginY())));
        this.getTextBlock().drawU(ug2);
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double y) {
        return 0.0;
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double y) {
        return this.getTextWidth(stringBounder);
    }
}

