/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.style;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;

class Context {
    private final List<String> data = new ArrayList<String>();

    Context() {
    }

    public Context push(String newString) {
        Context result = new Context();
        result.data.addAll(this.data);
        result.data.add(newString);
        return result;
    }

    public Context pop() {
        if (this.size() == 0) {
            throw new IllegalStateException();
        }
        Context result = new Context();
        result.data.addAll(this.data.subList(0, this.data.size() - 1));
        return result;
    }

    public String toString() {
        return this.data.toString();
    }

    public int size() {
        return this.data.size();
    }

    public Collection<StyleSignatureBasic> toSignatures() {
        ArrayList<StyleSignatureBasic> results = new ArrayList<StyleSignatureBasic>(Collections.singletonList(StyleSignatureBasic.empty()));
        boolean star = false;
        for (String s2 : this.data) {
            if (s2.endsWith("*")) {
                star = true;
                s2 = s2.substring(0, s2.length() - 1);
            }
            String[] names = s2.split(",");
            ArrayList<StyleSignatureBasic> tmp = new ArrayList<StyleSignatureBasic>();
            for (StyleSignatureBasic ss : results) {
                for (String name : names) {
                    tmp.add(ss.add(name.trim()));
                }
            }
            results = tmp;
        }
        if (star) {
            Iterator<String> it = results.listIterator();
            while (it.hasNext()) {
                StyleSignatureBasic tmp = ((StyleSignatureBasic)it.next()).addStar();
                it.set((String)((Object)tmp));
            }
        }
        return Collections.unmodifiableCollection(results);
    }
}

