/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.style;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.FileSystem;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.LineLocationImpl;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.SkinParam;
import znaishaded.net.sourceforge.plantuml.StringLocated;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.security.SFile;
import znaishaded.net.sourceforge.plantuml.style.AutomaticCounter;
import znaishaded.net.sourceforge.plantuml.style.Context;
import znaishaded.net.sourceforge.plantuml.style.CssVariables;
import znaishaded.net.sourceforge.plantuml.style.NoStyleAvailableException;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleBuilder;
import znaishaded.net.sourceforge.plantuml.style.StyleScheme;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.style.Value;
import znaishaded.net.sourceforge.plantuml.style.ValueImpl;

public class StyleLoader {
    public static final int DELTA_PRIORITY_FOR_STEREOTYPE = 1000;
    private final SkinParam skinParam;
    private StyleBuilder styleBuilder;
    private static final String KEYNAMES = "[-.\\w(), ]+?";
    private static final Pattern2 keyName = MyPattern.cmpile("^[:]?([-.\\w(), ]+?)([%s]+\\*)?[%s]*\\{$");
    private static final Pattern2 propertyAndValue = MyPattern.cmpile("^([\\w]+):?[%s]+(.*?);?$");
    private static final Pattern2 closeBracket = MyPattern.cmpile("^\\}$");

    public StyleLoader(SkinParam skinParam) {
        this.skinParam = skinParam;
    }

    public StyleBuilder loadSkin(String filename) throws IOException {
        this.styleBuilder = new StyleBuilder(this.skinParam);
        InputStream internalIs = StyleLoader.getInputStreamForStyle(filename);
        if (internalIs == null) {
            Log.error("No .skin file seems to be available");
            throw new NoStyleAvailableException();
        }
        BlocLines lines2 = BlocLines.load(internalIs, (LineLocation)new LineLocationImpl(filename, null));
        this.loadSkinInternal(lines2);
        if (this.styleBuilder == null) {
            Log.error("No .skin file seems to be available");
            throw new NoStyleAvailableException();
        }
        return this.styleBuilder;
    }

    public static InputStream getInputStreamForStyle(String filename) throws IOException {
        InputStream internalIs = null;
        SFile localFile = new SFile(filename);
        Log.info("Trying to load style " + filename);
        try {
            if (!localFile.exists()) {
                localFile = FileSystem.getInstance().getFile(filename);
            }
        }
        catch (IOException e) {
            Log.info("Cannot open file. " + e);
        }
        if (localFile.exists()) {
            Log.info("File found : " + localFile.getPrintablePath());
            internalIs = localFile.openFile();
        } else {
            Log.info("File not found : " + localFile.getPrintablePath());
            String res = "/skin/" + filename;
            internalIs = StyleLoader.class.getResourceAsStream(res);
            if (internalIs != null) {
                Log.info("... but " + filename + " found inside the .jar");
            }
        }
        return internalIs;
    }

    private void loadSkinInternal(BlocLines lines) {
        for (Style newStyle : StyleLoader.getDeclaredStyles(lines, this.styleBuilder)) {
            this.styleBuilder.loadInternal(newStyle.getSignature(), newStyle);
        }
    }

    public static Collection<Style> getDeclaredStyles(BlocLines lines, AutomaticCounter counter) {
        lines = lines.eventuallyMoveAllEmptyBracket();
        ArrayList<Style> result = new ArrayList<Style>();
        CssVariables variables = new CssVariables();
        StyleScheme scheme = StyleScheme.REGULAR;
        Context context = new Context();
        ArrayList maps = new ArrayList();
        boolean inComment = false;
        for (StringLocated s2 : lines) {
            Matcher2 mKeyNames;
            String trimmed = s2.getTrimmed().getString();
            if (trimmed.startsWith("/*") || trimmed.endsWith("*/") || trimmed.startsWith("/'") || trimmed.endsWith("'/")) continue;
            if (trimmed.startsWith("/*") || trimmed.startsWith("/'")) {
                inComment = true;
                continue;
            }
            if (trimmed.endsWith("*/") || trimmed.endsWith("'/")) {
                inComment = false;
                continue;
            }
            if (inComment) continue;
            if (trimmed.matches("@media.*dark.*\\{")) {
                scheme = StyleScheme.DARK;
                continue;
            }
            if (trimmed.startsWith("--")) {
                variables.learn(trimmed);
                continue;
            }
            int x = trimmed.lastIndexOf("//");
            if (x != -1) {
                trimmed = trimmed.substring(0, x).trim();
            }
            if ((mKeyNames = keyName.matcher(trimmed)).find()) {
                boolean isRecurse;
                String names = mKeyNames.group(1);
                boolean bl = isRecurse = mKeyNames.group(2) != null;
                if (isRecurse) {
                    names = names + "*";
                }
                context = context.push(names);
                maps.add(new EnumMap(PName.class));
                continue;
            }
            Matcher2 mPropertyAndValue = propertyAndValue.matcher(trimmed);
            if (mPropertyAndValue.find()) {
                PName key = PName.getFromName(mPropertyAndValue.group(1), scheme);
                String value = variables.value(mPropertyAndValue.group(2));
                if (key == null || maps.size() <= 0) continue;
                ((Map)maps.get(maps.size() - 1)).put(key, scheme == StyleScheme.REGULAR ? ValueImpl.regular(value, counter) : ValueImpl.dark(value, counter));
                continue;
            }
            Matcher2 mCloseBracket = closeBracket.matcher(trimmed);
            if (!mCloseBracket.find()) continue;
            if (context.size() > 0) {
                Collection<StyleSignatureBasic> signatures = context.toSignatures();
                for (StyleSignatureBasic signature : signatures) {
                    Map<PName, Value> tmp = (Map<PName, Value>)maps.get(maps.size() - 1);
                    if (signature.isWithDot()) {
                        tmp = StyleLoader.addPriorityForStereotype(tmp);
                    }
                    if (tmp.size() <= 0) continue;
                    Style style = new Style(signature, tmp);
                    result.add(style);
                }
                context = context.pop();
                maps.remove(maps.size() - 1);
                continue;
            }
            scheme = StyleScheme.REGULAR;
        }
        return Collections.unmodifiableList(result);
    }

    public static Map<PName, Value> addPriorityForStereotype(Map<PName, Value> tmp) {
        EnumMap<PName, Value> result = new EnumMap<PName, Value>(PName.class);
        for (Map.Entry<PName, Value> ent : tmp.entrySet()) {
            result.put(ent.getKey(), ((ValueImpl)ent.getValue()).addPriority(1000));
        }
        return result;
    }
}

