/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.extremity;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.svek.Side;
import znaishaded.net.sourceforge.plantuml.svek.extremity.Extremity;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

class ExtremityCrowfoot
extends Extremity {
    private final Point2D contact;
    private double angle;
    private final Side side;

    @Override
    public Point2D somePoint() {
        return this.contact;
    }

    public ExtremityCrowfoot(Point2D p1, double angle, Side side) {
        this.contact = new Point2D.Double(p1.getX(), p1.getY());
        this.angle = this.manageround(angle + 1.5707963267948966);
        this.side = side;
    }

    @Override
    public void drawU(UGraphic ug) {
        int xWing = 8;
        int yAperture = 8;
        AffineTransform rotate = AffineTransform.getRotateInstance(this.angle);
        Point2D.Double middle = new Point2D.Double(0.0, 0.0);
        Point2D.Double left = new Point2D.Double(0.0, -8.0);
        Point2D.Double base = new Point2D.Double(-8.0, 0.0);
        Point2D.Double right = new Point2D.Double(0.0, 8.0);
        rotate.transform(left, left);
        rotate.transform(base, base);
        rotate.transform(right, right);
        if (this.side == Side.WEST || this.side == Side.EAST) {
            ((Point2D)left).setLocation(((Point2D)middle).getX(), ((Point2D)left).getY());
            ((Point2D)right).setLocation(((Point2D)middle).getX(), ((Point2D)right).getY());
        }
        if (this.side == Side.SOUTH || this.side == Side.NORTH) {
            ((Point2D)left).setLocation(((Point2D)left).getX(), ((Point2D)middle).getY());
            ((Point2D)right).setLocation(((Point2D)right).getX(), ((Point2D)middle).getY());
        }
        ExtremityCrowfoot.drawLine(ug, this.contact.getX(), this.contact.getY(), base, left);
        ExtremityCrowfoot.drawLine(ug, this.contact.getX(), this.contact.getY(), base, right);
        ExtremityCrowfoot.drawLine(ug, this.contact.getX(), this.contact.getY(), base, middle);
    }

    private static void drawLine(UGraphic ug, double x, double y, Point2D p1, Point2D p2) {
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        ug.apply(new UTranslate(x + p1.getX(), y + p1.getY())).draw(new ULine(dx, dy));
    }
}

