/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.cucadiagram.EntityPosition;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Rankdir;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.Bibliotekon;
import znaishaded.net.sourceforge.plantuml.svek.Cluster;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;

public abstract class AbstractEntityImageBorder
extends AbstractEntityImage {
    public final EntityPosition entityPosition;
    protected final Cluster parent;
    protected final Bibliotekon bibliotekon;
    protected final Rankdir rankdir;
    protected final TextBlock desc;

    AbstractEntityImageBorder(ILeaf leaf, ISkinParam skinParam, Cluster parent, Bibliotekon bibliotekon, FontParam fontParam) {
        super(leaf, skinParam);
        this.parent = parent;
        this.bibliotekon = bibliotekon;
        this.entityPosition = leaf.getEntityPosition();
        this.rankdir = skinParam.getRankdir();
        if (this.entityPosition == EntityPosition.NORMAL) {
            throw new IllegalArgumentException();
        }
        Stereotype stereotype = leaf.getStereotype();
        FontConfiguration fc = FontConfiguration.create(skinParam, fontParam, stereotype);
        this.desc = leaf.getDisplay().create(fc, HorizontalAlignment.CENTER, skinParam);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.entityPosition.getDimension(this.rankdir);
    }

    public double getMaxWidthFromLabelForEntryExit(StringBounder stringBounder) {
        Dimension2D dimDesc = this.desc.calculateDimension(stringBounder);
        return dimDesc.getWidth();
    }

    @Override
    public ShapeType getShapeType() {
        return this.entityPosition.getShapeType();
    }
}

