/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.LineConfigurable;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IEntity;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public abstract class EntityImageStateCommon
extends AbstractEntityImage {
    protected final TextBlock desc;
    protected final Url url;
    protected final LineConfigurable lineConfig;

    public EntityImageStateCommon(IEntity entity, ISkinParam skinParam) {
        super(entity, skinParam);
        this.lineConfig = entity;
        FontConfiguration fontConfiguration = this.getStyleStateHeader().getFontConfiguration(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet(), entity.getColors());
        this.desc = entity.getDisplay().create8(fontConfiguration, HorizontalAlignment.CENTER, skinParam, CreoleMode.FULL, skinParam.wrapWidth());
        this.url = entity.getUrl99();
    }

    private Style getStyleStateHeader() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.stateDiagram, SName.state, SName.header).withTOBECHANGED(this.getEntity().getStereotype()).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    protected final Style getStyleState() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.stateDiagram, SName.state).withTOBECHANGED(this.getEntity().getStereotype()).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    private UStroke getStrokeWIP() {
        UStroke stroke = this.lineConfig.getColors().getSpecificLineStroke();
        if (stroke == null) {
            stroke = new UStroke(1.5);
        }
        return stroke;
    }

    @Override
    public final ShapeType getShapeType() {
        return ShapeType.ROUND_RECTANGLE;
    }

    protected final URectangle getShape(Dimension2D dimTotal) {
        double corner = this.getStyleState().value(PName.RoundCorner).asDouble();
        double deltaShadow = this.getStyleState().value(PName.Shadowing).asDouble();
        URectangle rect = new URectangle(dimTotal).rounded(corner);
        rect.setDeltaShadow(deltaShadow);
        return rect;
    }

    protected final UGraphic applyColor(UGraphic ug) {
        HColor border = this.lineConfig.getColors().getColor(ColorType.LINE);
        if (border == null) {
            border = this.getStyleState().value(PName.LineColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
        }
        ug = ug.apply(border);
        HColor backcolor = this.lineConfig.getColors().getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = this.getStyleState().value(PName.BackGroundColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
        }
        ug = ug.apply(backcolor.bg());
        return ug;
    }
}

