/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.tim.stdlib;

import java.util.List;
import java.util.Map;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.json.JsonObject;
import znaishaded.net.sourceforge.plantuml.json.JsonValue;
import znaishaded.net.sourceforge.plantuml.tim.EaterException;
import znaishaded.net.sourceforge.plantuml.tim.EaterExceptionLocated;
import znaishaded.net.sourceforge.plantuml.tim.TContext;
import znaishaded.net.sourceforge.plantuml.tim.TFunctionSignature;
import znaishaded.net.sourceforge.plantuml.tim.TMemory;
import znaishaded.net.sourceforge.plantuml.tim.expression.TValue;
import znaishaded.net.sourceforge.plantuml.tim.stdlib.SimpleReturnFunction;

public class JsonKeyExists
extends SimpleReturnFunction {
    @Override
    public TFunctionSignature getSignature() {
        return new TFunctionSignature("%json_key_exists", 1);
    }

    @Override
    public boolean canCover(int nbArg, Set<String> namedArgument) {
        return nbArg == 2;
    }

    @Override
    public TValue executeReturnFunction(TContext context, TMemory memory, LineLocation location, List<TValue> values, Map<String, TValue> named) throws EaterException, EaterExceptionLocated {
        TValue arg0 = values.get(0);
        if (!arg0.isJson()) {
            return TValue.fromBoolean(false);
        }
        JsonValue json = arg0.toJson();
        if (!json.isObject()) {
            return TValue.fromBoolean(false);
        }
        TValue arg1 = values.get(1);
        if (!arg1.isString()) {
            return TValue.fromBoolean(false);
        }
        JsonObject object = (JsonObject)json;
        String keyname = arg1.toString();
        if (object.contains(keyname)) {
            return TValue.fromBoolean(true);
        }
        return TValue.fromBoolean(false);
    }
}

