/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.timingdiagram;

import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LinkDecor;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LinkType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.WithLinkType;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleBuilder;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.timingdiagram.Player;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TickInPlayer;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimeTick;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class TimeMessage
extends WithLinkType {
    private final TickInPlayer tickInPlayer1;
    private final TickInPlayer tickInPlayer2;
    private final Display label;
    private final ISkinParam skinParam;
    private final StyleBuilder styleBuilder;

    public TimeMessage(TickInPlayer tickInPlayer1, TickInPlayer tickInPlayer2, String label, ISkinParam skinParam) {
        this.skinParam = skinParam;
        this.styleBuilder = skinParam.getCurrentStyleBuilder();
        this.tickInPlayer1 = tickInPlayer1;
        this.tickInPlayer2 = tickInPlayer2;
        this.label = Display.getWithNewlines(label);
        this.setSpecificColor(this.getColor());
        this.type = new LinkType(LinkDecor.NONE, LinkDecor.NONE);
    }

    @Override
    public UStroke getUStroke() {
        if (this.styleBuilder == null) {
            return new UStroke(1.5);
        }
        return this.getStyle().getStroke();
    }

    private HColor getColor() {
        if (this.styleBuilder == null) {
            return HColorUtils.MY_RED;
        }
        return this.getStyle().value(PName.LineColor).asColor(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet());
    }

    private Style getStyle() {
        return this.getStyleSignature().getMergedStyle(this.styleBuilder);
    }

    private StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.timingDiagram, SName.arrow);
    }

    public final Player getPlayer1() {
        return this.tickInPlayer1.getPlayer();
    }

    public final Player getPlayer2() {
        return this.tickInPlayer2.getPlayer();
    }

    public final TimeTick getTick1() {
        return this.tickInPlayer1.getTick();
    }

    public final TimeTick getTick2() {
        return this.tickInPlayer2.getTick();
    }

    public final Display getLabel() {
        return this.label;
    }

    @Override
    public void goNorank() {
    }
}

