/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.timingdiagram.graphic;

import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.WithLinkType;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.UDrawable;
import znaishaded.net.sourceforge.plantuml.timingdiagram.graphic.IntricatedPoint;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class TimeArrow
implements UDrawable {
    private final Point2D start;
    private final Point2D end;
    private final Display label;
    private final ISkinSimple spriteContainer;
    private final WithLinkType type;

    public static TimeArrow create(IntricatedPoint pt1, IntricatedPoint pt2, Display label, ISkinSimple spriteContainer, WithLinkType type) {
        TimeArrow arrow1 = new TimeArrow(pt1.getPointA(), pt2.getPointA(), label, spriteContainer, type);
        TimeArrow arrow2 = new TimeArrow(pt1.getPointA(), pt2.getPointB(), label, spriteContainer, type);
        TimeArrow arrow3 = new TimeArrow(pt1.getPointB(), pt2.getPointA(), label, spriteContainer, type);
        TimeArrow arrow4 = new TimeArrow(pt1.getPointB(), pt2.getPointB(), label, spriteContainer, type);
        return TimeArrow.shorter(arrow1, arrow2, arrow3, arrow4);
    }

    private TimeArrow(Point2D start, Point2D end, Display label, ISkinSimple spriteContainer, WithLinkType type) {
        this.start = start;
        this.type = type;
        this.end = end;
        this.label = label;
        this.spriteContainer = spriteContainer;
    }

    private double getAngle() {
        return Math.atan2(this.end.getX() - this.start.getX(), this.end.getY() - this.start.getY());
    }

    private static TimeArrow shorter(TimeArrow arrow1, TimeArrow arrow2) {
        if (arrow1.len() < arrow2.len()) {
            return arrow1;
        }
        return arrow2;
    }

    private static TimeArrow shorter(TimeArrow arrow1, TimeArrow arrow2, TimeArrow arrow3, TimeArrow arrow4) {
        return TimeArrow.shorter(TimeArrow.shorter(arrow1, arrow2), TimeArrow.shorter(arrow3, arrow4));
    }

    private double len() {
        return this.start.distance(this.end);
    }

    public TimeArrow translate(UTranslate translate) {
        return new TimeArrow(translate.getTranslated(this.start), translate.getTranslated(this.end), this.label, this.spriteContainer, this.type);
    }

    public static Point2D onCircle(Point2D pt, double alpha) {
        double radius = 8.0;
        double x = pt.getX() - Math.sin(alpha) * 8.0;
        double y = pt.getY() - Math.cos(alpha) * 8.0;
        return new Point2D.Double(x, y);
    }

    private FontConfiguration getFontConfiguration() {
        UFont font = UFont.serif(14);
        HColor color = this.type.getSpecificColor();
        return FontConfiguration.create(font, color, color, false);
    }

    @Override
    public void drawU(UGraphic ug) {
        double angle = this.getAngle();
        ug = ug.apply(this.type.getSpecificColor()).apply(this.type.getUStroke());
        ULine line = new ULine(this.end.getX() - this.start.getX(), this.end.getY() - this.start.getY());
        ug.apply(new UTranslate(this.start)).draw(line);
        double delta = 0.3490658503988659;
        Point2D pt1 = TimeArrow.onCircle(this.end, angle + 0.3490658503988659);
        Point2D pt2 = TimeArrow.onCircle(this.end, angle - 0.3490658503988659);
        UPolygon polygon = new UPolygon();
        polygon.addPoint(pt1.getX(), pt1.getY());
        polygon.addPoint(pt2.getX(), pt2.getY());
        polygon.addPoint(this.end.getX(), this.end.getY());
        ug = ug.apply(this.type.getSpecificColor().bg());
        ug.draw(polygon);
        TextBlock textLabel = this.label.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.spriteContainer);
        double xText = (pt1.getX() + pt2.getX()) / 2.0;
        double yText = (pt1.getY() + pt2.getY()) / 2.0;
        if (this.start.getY() < this.end.getY()) {
            Dimension2D dimLabel = textLabel.calculateDimension(ug.getStringBounder());
            yText -= dimLabel.getHeight();
        }
        textLabel.drawU(ug.apply(new UTranslate(xText, yText)));
    }
}

