/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic;

import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.creole.Stencil;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.ugraphic.AbstractUGraphicHorizontalLine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UHorizontalLine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class UGraphicStencil
extends AbstractUGraphicHorizontalLine {
    private final Stencil stencil;
    private final UStroke defaultStroke;

    public static UGraphic create(UGraphic ug, Stencil stencil, UStroke defaultStroke) {
        return new UGraphicStencil(ug, stencil, defaultStroke);
    }

    public static UGraphic create(UGraphic ug, Dimension2D dim) {
        return new UGraphicStencil(ug, UGraphicStencil.getRectangleStencil(dim), new UStroke());
    }

    private static Stencil getRectangleStencil(final Dimension2D dim) {
        return new Stencil(){

            @Override
            public double getStartingX(StringBounder stringBounder, double y) {
                return 0.0;
            }

            @Override
            public double getEndingX(StringBounder stringBounder, double y) {
                return dim.getWidth();
            }
        };
    }

    private UGraphicStencil(UGraphic ug, Stencil stencil, UStroke defaultStroke) {
        super(ug);
        this.stencil = stencil;
        this.defaultStroke = defaultStroke;
    }

    @Override
    protected AbstractUGraphicHorizontalLine copy(UGraphic ug) {
        return new UGraphicStencil(ug, this.stencil, this.defaultStroke);
    }

    @Override
    protected void drawHline(UGraphic ug, UHorizontalLine line, UTranslate translate) {
        line.drawLineInternal(ug, this.stencil, translate.getDy(), this.defaultStroke);
    }
}

