/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.BasicStroke;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.EnsureVisible;
import znaishaded.net.sourceforge.plantuml.ugraphic.UDriver;
import znaishaded.net.sourceforge.plantuml.ugraphic.UParam;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorGradient;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;
import znaishaded.net.sourceforge.plantuml.ugraphic.g2d.DriverLineG2d;
import znaishaded.net.sourceforge.plantuml.ugraphic.g2d.DriverRectangleG2d;
import znaishaded.net.sourceforge.plantuml.ugraphic.g2d.DriverShadowedG2d;

public class DriverPolygonG2d
extends DriverShadowedG2d
implements UDriver<UPolygon, Graphics2D> {
    private final double dpiFactor;
    private final EnsureVisible visible;

    public DriverPolygonG2d(double dpiFactor, EnsureVisible visible) {
        this.dpiFactor = dpiFactor;
        this.visible = visible;
    }

    @Override
    public void draw(UPolygon shape, double x, double y, ColorMapper mapper, UParam param, Graphics2D g2d) {
        g2d.setStroke(new BasicStroke((float)param.getStroke().getThickness()));
        GeneralPath path = new GeneralPath();
        HColor back = param.getBackcolor();
        Point2D.Double last = null;
        for (Point2D point2D : shape.getPoints()) {
            double xp = point2D.getX() + x;
            double yp = point2D.getY() + y;
            this.visible.ensureVisible(xp, yp);
            if (last == null) {
                path.moveTo((float)xp, (float)yp);
            } else {
                path.lineTo((float)xp, (float)yp);
            }
            last = new Point2D.Double(xp, yp);
        }
        if (last != null) {
            path.closePath();
        }
        if (shape.getDeltaShadow() != 0.0) {
            if (HColorUtils.isTransparent(back)) {
                this.drawOnlyLineShadowSpecial(g2d, path, shape.getDeltaShadow(), this.dpiFactor);
            } else {
                this.drawShadow(g2d, path, shape.getDeltaShadow(), this.dpiFactor);
            }
        }
        if (back instanceof HColorGradient) {
            HColorGradient gr = (HColorGradient)back;
            char c = gr.getPolicy();
            GradientPaint paint = c == '|' ? new GradientPaint((float)x, (float)(y + shape.getHeight()) / 2.0f, mapper.toColor(gr.getColor1()), (float)(x + shape.getWidth()), (float)(y + shape.getHeight()) / 2.0f, mapper.toColor(gr.getColor2())) : (c == '\\' ? new GradientPaint((float)x, (float)(y + shape.getHeight()), mapper.toColor(gr.getColor1()), (float)(x + shape.getWidth()), (float)y, mapper.toColor(gr.getColor2())) : (c == '-' ? new GradientPaint((float)(x + shape.getWidth()) / 2.0f, (float)y, mapper.toColor(gr.getColor1()), (float)(x + shape.getWidth()) / 2.0f, (float)(y + shape.getHeight()), mapper.toColor(gr.getColor2())) : new GradientPaint((float)x, (float)y, mapper.toColor(gr.getColor1()), (float)(x + shape.getWidth()), (float)(y + shape.getHeight()), mapper.toColor(gr.getColor2()))));
            g2d.setPaint(paint);
            g2d.fill(path);
        } else if (back != null) {
            g2d.setColor(mapper.toColor(back));
            DriverRectangleG2d.managePattern(param, g2d);
            g2d.fill(path);
        }
        if (param.getColor() != null) {
            g2d.setColor(mapper.toColor(param.getColor()));
            DriverLineG2d.manageStroke(param, g2d);
            g2d.draw(path);
        }
    }
}

