/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.html5;

import java.awt.geom.Rectangle2D;
import znaishaded.net.sourceforge.plantuml.ugraphic.ClipContainer;
import znaishaded.net.sourceforge.plantuml.ugraphic.UClip;
import znaishaded.net.sourceforge.plantuml.ugraphic.UDriver;
import znaishaded.net.sourceforge.plantuml.ugraphic.UParam;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorGradient;
import znaishaded.net.sourceforge.plantuml.ugraphic.html5.Html5Drawer;

public class DriverRectangleHtml5
implements UDriver<URectangle, Html5Drawer> {
    private final ClipContainer clipContainer;

    public DriverRectangleHtml5(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(URectangle rect, double x, double y, ColorMapper mapper, UParam param, Html5Drawer html) {
        double width = rect.getWidth();
        double height = rect.getHeight();
        UClip clip = this.clipContainer.getClip();
        if (clip != null) {
            Rectangle2D.Double r = clip.getClippedRectangle(new Rectangle2D.Double(x, y, width, height));
            x = r.x;
            y = r.y;
            width = r.width;
            height = r.height;
        }
        double rx = rect.getRx();
        double ry = rect.getRy();
        HColor back = param.getBackcolor();
        if (!(back instanceof HColorGradient)) {
            String color = param.getColor() == null ? null : mapper.toRGB(param.getColor());
            String backcolor = param.getColor() == null ? null : mapper.toRGB(param.getBackcolor());
            html.setStrokeColor(color);
            html.setFillColor(backcolor);
            html.htmlRectangle(x, y, width, height, rx / 2.0, ry / 2.0);
        }
    }
}

