/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.svg;

import znaishaded.net.sourceforge.plantuml.svg.SvgGraphics;
import znaishaded.net.sourceforge.plantuml.ugraphic.ClipContainer;
import znaishaded.net.sourceforge.plantuml.ugraphic.UClip;
import znaishaded.net.sourceforge.plantuml.ugraphic.UDriver;
import znaishaded.net.sourceforge.plantuml.ugraphic.UParam;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPath;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.g2d.DriverShadowedG2d;
import znaishaded.net.sourceforge.plantuml.ugraphic.svg.DriverRectangleSvg;

public class DriverPathSvg
extends DriverShadowedG2d
implements UDriver<UPath, SvgGraphics> {
    private final ClipContainer clipContainer;

    public DriverPathSvg(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UPath shape, double x, double y, ColorMapper mapper, UParam param, SvgGraphics svg) {
        UClip clip = this.clipContainer.getClip();
        if (clip != null && !clip.isInside(x, y, shape)) {
            return;
        }
        if (shape.isOpenIconic()) {
            HColor dark;
            HColor color = param.getColor();
            HColor hColor = dark = color == null ? null : color.darkSchemeTheme();
            if (dark == color) {
                svg.setFillColor(mapper.toSvg(color));
            } else {
                svg.setFillColor(mapper.toSvg(color), mapper.toSvg(dark));
            }
            svg.setStrokeColor("");
            svg.setStrokeWidth(0.0, "");
        } else {
            DriverRectangleSvg.applyFillColor(svg, mapper, param);
            DriverRectangleSvg.applyStrokeColor(svg, mapper, param);
            svg.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDasharraySvg());
        }
        svg.svgPath(x, y, shape, shape.getDeltaShadow());
    }
}

