/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.txt;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.asciiart.TextStringBounder;
import znaishaded.net.sourceforge.plantuml.asciiart.TranslatedCharArea;
import znaishaded.net.sourceforge.plantuml.asciiart.UmlCharArea;
import znaishaded.net.sourceforge.plantuml.asciiart.UmlCharAreaImpl;
import znaishaded.net.sourceforge.plantuml.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.graphic.FontStyle;
import znaishaded.net.sourceforge.plantuml.security.SecurityUtils;
import znaishaded.net.sourceforge.plantuml.ugraphic.AbstractCommonUGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ClipContainer;
import znaishaded.net.sourceforge.plantuml.ugraphic.UImage;
import znaishaded.net.sourceforge.plantuml.ugraphic.UShape;
import znaishaded.net.sourceforge.plantuml.ugraphic.UText;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class UGraphicTxt
extends AbstractCommonUGraphic
implements ClipContainer {
    private final UmlCharArea charArea;

    @Override
    protected AbstractCommonUGraphic copyUGraphic() {
        return new UGraphicTxt(this);
    }

    private UGraphicTxt(UGraphicTxt other) {
        super(other);
        this.charArea = other.charArea;
    }

    public UGraphicTxt() {
        super(HColorUtils.BLACK, new ColorMapperIdentity(), new TextStringBounder());
        this.charArea = new UmlCharAreaImpl();
    }

    public void draw(UShape shape) {
        if (shape instanceof UText) {
            UText txt = (UText)shape;
            int y = (int)(this.getTranslateY() + txt.getDescent(this.getStringBounder())) / 10;
            if (txt.getFontConfiguration().containsStyle(FontStyle.WAVE)) {
                this.charArea.drawHLine('^', y, this.getDx(), txt.getText().length());
                this.charArea.drawStringLR(txt.getText(), this.getDx(), y + 1);
            } else {
                this.charArea.drawStringLR(txt.getText(), this.getDx(), y);
            }
            return;
        }
        if (shape instanceof UImage) {
            return;
        }
    }

    public final UmlCharArea getCharArea() {
        return new TranslatedCharArea(this.charArea, this.getDx(), this.getDy());
    }

    private int getDy() {
        return (int)this.getTranslateY();
    }

    private int getDx() {
        return (int)this.getTranslateX();
    }

    public Dimension2D getDimension() {
        return new Dimension2DDouble(0.0, 0.0);
    }

    @Override
    public void writeToStream(OutputStream os, String metadata, int dpi) throws IOException {
        PrintStream ps = SecurityUtils.createPrintStream(os, true, StandardCharsets.UTF_8);
        this.getCharArea().print(ps);
    }
}

