/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.wbs;

import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileBoxOld;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.mindmap.IdeaShape;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleBuilder;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.wbs.WElement;

abstract class WBSTextBlock
extends AbstractTextBlock {
    protected final ISkinParam skinParam;
    private final StyleBuilder styleBuilder;
    private final int level;

    public WBSTextBlock(ISkinParam skinParam, StyleBuilder styleBuilder, int level) {
        this.skinParam = skinParam;
        this.styleBuilder = styleBuilder;
        this.level = level;
    }

    protected final void drawLine(UGraphic ug, Point2D p1, Point2D p2) {
        ULine line = new ULine(p1, p2);
        this.getStyleUsed().applyStrokeAndLineColor(ug.apply(new UTranslate(p1)), this.skinParam.getIHtmlColorSet(), this.skinParam.getThemeStyle()).draw(line);
    }

    private Style getStyleUsed() {
        return this.getDefaultStyleDefinitionArrow().getMergedStyle(this.styleBuilder);
    }

    protected final void drawLine(UGraphic ug, double x1, double y1, double x2, double y2) {
        this.drawLine(ug, new Point2D.Double(Math.min(x1, x2), y1), new Point2D.Double(Math.max(x1, x2), y2));
    }

    public final StyleSignatureBasic getDefaultStyleDefinitionArrow() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.wbsDiagram, SName.arrow).add(SName.depth(this.level));
    }

    protected final TextBlock buildMain(WElement idea) {
        Display label = idea.getLabel();
        Style style = idea.getStyle();
        if (idea.getShape() == IdeaShape.BOX) {
            return FtileBoxOld.createWbs(style, idea.withBackColor(this.skinParam), label);
        }
        TextBlock text = label.create0(style.getFontConfiguration(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet()), style.getHorizontalAlignment(), this.skinParam, style.wrapWidth(), CreoleMode.FULL, null, null);
        return TextBlockUtils.withMargin(text, 0.0, 3.0, 1.0, 1.0);
    }
}

