/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.webp;

import java.io.IOException;
import znaishaded.net.sourceforge.plantuml.webp.Globals;
import znaishaded.net.sourceforge.plantuml.webp.IDCT;
import znaishaded.net.sourceforge.plantuml.webp.SubBlock;
import znaishaded.net.sourceforge.plantuml.webp.VP8Frame;

public class MacroBlock {
    private int filterLevel;
    private boolean keepDebugInfo = false;
    private int segmentId;
    private int skipCoeff;
    private boolean skipInnerLoopFilter;
    SubBlock[][] uSubBlocks;
    private int uVFilterLevel;
    private int uvMode;
    SubBlock[][] vSubBlocks;
    private int x;
    private int y;
    SubBlock y2SubBlock;
    private int yMode;
    SubBlock[][] ySubBlocks;

    MacroBlock(int x, int y, boolean keepDebugInfo) {
        int j;
        int i;
        this.x = x - 1;
        this.y = y - 1;
        this.keepDebugInfo = keepDebugInfo;
        this.ySubBlocks = new SubBlock[4][4];
        this.uSubBlocks = new SubBlock[2][2];
        this.vSubBlocks = new SubBlock[2][2];
        SubBlock above = null;
        SubBlock left = null;
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 4; ++j) {
                left = null;
                above = null;
                if (j > 0) {
                    left = this.ySubBlocks[j - 1][i];
                }
                if (i > 0) {
                    above = this.ySubBlocks[j][i - 1];
                }
                this.ySubBlocks[j][i] = new SubBlock(this, above, left, SubBlock.PLANE.Y1);
            }
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 2; ++j) {
                left = null;
                above = null;
                if (j > 0) {
                    left = this.uSubBlocks[j - 1][i];
                }
                if (i > 0) {
                    above = this.uSubBlocks[j][i - 1];
                }
                this.uSubBlocks[j][i] = new SubBlock(this, above, left, SubBlock.PLANE.U);
            }
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 2; ++j) {
                left = null;
                above = null;
                if (j > 0) {
                    left = this.vSubBlocks[j - 1][i];
                }
                if (i > 0) {
                    above = this.vSubBlocks[j][i - 1];
                }
                this.vSubBlocks[j][i] = new SubBlock(this, above, left, SubBlock.PLANE.V);
            }
        }
        this.y2SubBlock = new SubBlock(this, null, null, SubBlock.PLANE.Y2);
    }

    public void decodeMacroBlock(VP8Frame frame) throws IOException {
        MacroBlock mb = this;
        if (mb.getSkipCoeff() > 0) {
            if (mb.getYMode() != 4) {
                mb.skipInnerLoopFilter = true;
            }
        } else if (mb.getYMode() != 4) {
            this.decodeMacroBlockTokens(frame, true);
        } else {
            this.decodeMacroBlockTokens(frame, false);
        }
    }

    private void decodeMacroBlockTokens(VP8Frame frame, boolean withY2) throws IOException {
        this.skipInnerLoopFilter = false;
        if (withY2) {
            this.skipInnerLoopFilter |= this.decodePlaneTokens(frame, 1, SubBlock.PLANE.Y2, false);
        }
        this.skipInnerLoopFilter |= this.decodePlaneTokens(frame, 4, SubBlock.PLANE.Y1, withY2);
        this.skipInnerLoopFilter |= this.decodePlaneTokens(frame, 2, SubBlock.PLANE.U, false);
        this.skipInnerLoopFilter |= this.decodePlaneTokens(frame, 2, SubBlock.PLANE.V, false);
        this.skipInnerLoopFilter = !this.skipInnerLoopFilter;
    }

    private boolean decodePlaneTokens(VP8Frame frame, int dimentions, SubBlock.PLANE plane, boolean withY2) throws IOException {
        MacroBlock mb = this;
        boolean r = false;
        for (int y = 0; y < dimentions; ++y) {
            for (int x = 0; x < dimentions; ++x) {
                int L = 0;
                int A2 = 0;
                int lc = 0;
                SubBlock sb = mb.getSubBlock(plane, x, y);
                SubBlock left = frame.getLeftSubBlock(sb, plane);
                SubBlock above = frame.getAboveSubBlock(sb, plane);
                if (left.hasNoZeroToken()) {
                    L = 1;
                }
                lc += L;
                if (above.hasNoZeroToken()) {
                    A2 = 1;
                }
                sb.decodeSubBlock(frame.getTokenBoolDecoder(), frame.getCoefProbs(), lc += A2, SubBlock.planeToType(plane, withY2), withY2);
                r |= sb.hasNoZeroToken();
            }
        }
        return r;
    }

    public void dequantMacroBlock(VP8Frame frame) {
        MacroBlock mb = this;
        if (mb.getYMode() != 4) {
            SubBlock sb = mb.getY2SubBlock();
            int acQValue = frame.getSegmentQuants().getSegQuants()[this.getSegmentId()].getY2ac_delta_q();
            int dcQValue = frame.getSegmentQuants().getSegQuants()[this.getSegmentId()].getY2dc();
            int[] input = new int[16];
            input[0] = sb.getTokens()[0] * dcQValue;
            for (int x = 1; x < 16; ++x) {
                input[x] = sb.getTokens()[x] * acQValue;
            }
            sb.setDiff(IDCT.iwalsh4x4(input));
            for (int j = 0; j < 4; ++j) {
                for (int i = 0; i < 4; ++i) {
                    SubBlock ysb = mb.getYSubBlock(i, j);
                    ysb.dequantSubBlock(frame, sb.getDiff()[i][j]);
                }
            }
            mb.predictY(frame);
            mb.predictUV(frame);
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    SubBlock uvsb = mb.getUSubBlock(j, i);
                    uvsb.dequantSubBlock(frame, null);
                    uvsb = mb.getVSubBlock(i, j);
                    uvsb.dequantSubBlock(frame, null);
                }
            }
            mb.recon_mb();
        } else {
            int j;
            int i;
            SubBlock sb;
            for (int j2 = 0; j2 < 4; ++j2) {
                for (int i2 = 0; i2 < 4; ++i2) {
                    sb = mb.getYSubBlock(i2, j2);
                    sb.dequantSubBlock(frame, null);
                    sb.predict(frame);
                    sb.reconstruct();
                }
            }
            mb.predictUV(frame);
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 2; ++j) {
                    sb = mb.getUSubBlock(j, i);
                    sb.dequantSubBlock(frame, null);
                    sb.reconstruct();
                }
            }
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 2; ++j) {
                    sb = mb.getVSubBlock(j, i);
                    sb.dequantSubBlock(frame, null);
                    sb.reconstruct();
                }
            }
        }
    }

    public void drawDebug() {
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < 4; ++i) {
                SubBlock sb = this.ySubBlocks[i][0];
                sb.drawDebugH();
                sb = this.ySubBlocks[0][j];
                sb.drawDebugV();
            }
        }
    }

    public SubBlock getBottomSubBlock(int x, SubBlock.PLANE plane) {
        if (plane == SubBlock.PLANE.Y1) {
            return this.ySubBlocks[x][3];
        }
        if (plane == SubBlock.PLANE.U) {
            return this.uSubBlocks[x][1];
        }
        if (plane == SubBlock.PLANE.V) {
            return this.vSubBlocks[x][1];
        }
        if (plane == SubBlock.PLANE.Y2) {
            return this.y2SubBlock;
        }
        return null;
    }

    public String getDebugString() {
        String r = new String();
        r = r + " YMode: " + Globals.getModeAsString(this.yMode);
        r = r + "\n UVMode: " + Globals.getModeAsString(this.uvMode);
        r = r + "\n SegmentID: " + this.segmentId;
        r = r + "\n Filter Level: " + this.filterLevel;
        r = r + "\n UV Filter Level: " + this.uVFilterLevel;
        r = r + "\n Skip Coeff: " + this.skipCoeff;
        return r;
    }

    public int getFilterLevel() {
        return this.filterLevel;
    }

    public SubBlock getLeftSubBlock(int y, SubBlock.PLANE plane) {
        if (plane == SubBlock.PLANE.Y1) {
            return this.ySubBlocks[0][y];
        }
        if (plane == SubBlock.PLANE.V) {
            return this.vSubBlocks[0][y];
        }
        if (plane == SubBlock.PLANE.Y2) {
            return this.y2SubBlock;
        }
        if (plane == SubBlock.PLANE.U) {
            return this.uSubBlocks[0][y];
        }
        return null;
    }

    public SubBlock getRightSubBlock(int y, SubBlock.PLANE plane) {
        if (plane == SubBlock.PLANE.Y1) {
            return this.ySubBlocks[3][y];
        }
        if (plane == SubBlock.PLANE.U) {
            return this.uSubBlocks[1][y];
        }
        if (plane == SubBlock.PLANE.V) {
            return this.vSubBlocks[1][y];
        }
        if (plane == SubBlock.PLANE.Y2) {
            return this.y2SubBlock;
        }
        return null;
    }

    public int getSkipCoeff() {
        return this.skipCoeff;
    }

    public SubBlock getSubBlock(SubBlock.PLANE plane, int i, int j) {
        switch (plane) {
            case Y1: {
                return this.getYSubBlock(i, j);
            }
            case U: {
                return this.getUSubBlock(i, j);
            }
            case V: {
                return this.getVSubBlock(i, j);
            }
            case Y2: {
                return this.getY2SubBlock();
            }
        }
        return null;
    }

    public int getSubblockX(SubBlock sb) {
        if (sb.getPlane() == SubBlock.PLANE.Y1) {
            for (int y = 0; y < 4; ++y) {
                for (int x = 0; x < 4; ++x) {
                    if (this.ySubBlocks[x][y] != sb) continue;
                    return x;
                }
            }
        } else if (sb.getPlane() == SubBlock.PLANE.U) {
            for (int y = 0; y < 2; ++y) {
                for (int x = 0; x < 2; ++x) {
                    if (this.uSubBlocks[x][y] != sb) continue;
                    return x;
                }
            }
        } else if (sb.getPlane() == SubBlock.PLANE.V) {
            for (int y = 0; y < 2; ++y) {
                for (int x = 0; x < 2; ++x) {
                    if (this.vSubBlocks[x][y] != sb) continue;
                    return x;
                }
            }
        } else if (sb.getPlane() == SubBlock.PLANE.Y2) {
            return 0;
        }
        return -100;
    }

    public int getSubblockY(SubBlock sb) {
        if (sb.getPlane() == SubBlock.PLANE.Y1) {
            for (int y = 0; y < 4; ++y) {
                for (int x = 0; x < 4; ++x) {
                    if (this.ySubBlocks[x][y] != sb) continue;
                    return y;
                }
            }
        } else if (sb.getPlane() == SubBlock.PLANE.U) {
            for (int y = 0; y < 2; ++y) {
                for (int x = 0; x < 2; ++x) {
                    if (this.uSubBlocks[x][y] != sb) continue;
                    return y;
                }
            }
        } else if (sb.getPlane() == SubBlock.PLANE.V) {
            for (int y = 0; y < 2; ++y) {
                for (int x = 0; x < 2; ++x) {
                    if (this.vSubBlocks[x][y] != sb) continue;
                    return y;
                }
            }
        } else if (sb.getPlane() == SubBlock.PLANE.Y2) {
            return 0;
        }
        return -100;
    }

    public SubBlock getUSubBlock(int i, int j) {
        return this.uSubBlocks[i][j];
    }

    public int getUVFilterLevel() {
        return this.uVFilterLevel;
    }

    public int getUvMode() {
        return this.uvMode;
    }

    public SubBlock getVSubBlock(int i, int j) {
        return this.vSubBlocks[i][j];
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public SubBlock getY2SubBlock() {
        return this.y2SubBlock;
    }

    public int getYMode() {
        return this.yMode;
    }

    public SubBlock getYSubBlock(int i, int j) {
        return this.ySubBlocks[i][j];
    }

    public boolean isKeepDebugInfo() {
        return this.keepDebugInfo;
    }

    public boolean isSkip_inner_lf() {
        return this.skipInnerLoopFilter;
    }

    public void predictUV(VP8Frame frame) {
        MacroBlock aboveMb = frame.getMacroBlock(this.x, this.y - 1);
        MacroBlock leftMb = frame.getMacroBlock(this.x - 1, this.y);
        switch (this.uvMode) {
            case 0: {
                int x;
                int y;
                boolean up_available = false;
                boolean left_available = false;
                int Uaverage = 0;
                int Vaverage = 0;
                int expected_udc = 0;
                int expected_vdc = 0;
                if (this.x > 0) {
                    left_available = true;
                }
                if (this.y > 0) {
                    up_available = true;
                }
                if (up_available || left_available) {
                    int i;
                    SubBlock vsb;
                    SubBlock usb;
                    int j;
                    if (up_available) {
                        for (j = 0; j < 2; ++j) {
                            usb = aboveMb.getUSubBlock(j, 1);
                            vsb = aboveMb.getVSubBlock(j, 1);
                            for (i = 0; i < 4; ++i) {
                                Uaverage += usb.getDest()[i][3];
                                Vaverage += vsb.getDest()[i][3];
                            }
                        }
                    }
                    if (left_available) {
                        for (j = 0; j < 2; ++j) {
                            usb = leftMb.getUSubBlock(1, j);
                            vsb = leftMb.getVSubBlock(1, j);
                            for (i = 0; i < 4; ++i) {
                                Uaverage += usb.getDest()[3][i];
                                Vaverage += vsb.getDest()[3][i];
                            }
                        }
                    }
                    int shift = 2;
                    if (up_available) {
                        ++shift;
                    }
                    if (left_available) {
                        ++shift;
                    }
                    expected_udc = Uaverage + (1 << shift - 1) >> shift;
                    expected_vdc = Vaverage + (1 << shift - 1) >> shift;
                } else {
                    expected_udc = 128;
                    expected_vdc = 128;
                }
                int[][] ufill = new int[4][4];
                for (int y2 = 0; y2 < 4; ++y2) {
                    for (int x2 = 0; x2 < 4; ++x2) {
                        ufill[x2][y2] = expected_udc;
                    }
                }
                int[][] vfill = new int[4][4];
                for (y = 0; y < 4; ++y) {
                    for (x = 0; x < 4; ++x) {
                        vfill[x][y] = expected_vdc;
                    }
                }
                for (y = 0; y < 2; ++y) {
                    for (x = 0; x < 2; ++x) {
                        SubBlock usb = this.uSubBlocks[x][y];
                        SubBlock vsb = this.vSubBlocks[x][y];
                        usb.setPredict(ufill);
                        vsb.setPredict(vfill);
                    }
                }
                break;
            }
            case 1: {
                SubBlock[] aboveUSb = new SubBlock[2];
                SubBlock[] aboveVSb = new SubBlock[2];
                for (int x = 0; x < 2; ++x) {
                    aboveUSb[x] = aboveMb.getUSubBlock(x, 1);
                    aboveVSb[x] = aboveMb.getVSubBlock(x, 1);
                }
                for (int y = 0; y < 2; ++y) {
                    for (int x = 0; x < 2; ++x) {
                        SubBlock usb = this.uSubBlocks[y][x];
                        SubBlock vsb = this.vSubBlocks[y][x];
                        int[][] ublock = new int[4][4];
                        int[][] vblock = new int[4][4];
                        for (int j = 0; j < 4; ++j) {
                            for (int i = 0; i < 4; ++i) {
                                ublock[j][i] = aboveUSb[y].getMacroBlockPredict(1)[j][3];
                                vblock[j][i] = aboveVSb[y].getMacroBlockPredict(1)[j][3];
                            }
                        }
                        usb.setPredict(ublock);
                        vsb.setPredict(vblock);
                    }
                }
                break;
            }
            case 2: {
                SubBlock[] leftUSb = new SubBlock[2];
                SubBlock[] leftVSb = new SubBlock[2];
                for (int x = 0; x < 2; ++x) {
                    leftUSb[x] = leftMb.getUSubBlock(1, x);
                    leftVSb[x] = leftMb.getVSubBlock(1, x);
                }
                for (int y = 0; y < 2; ++y) {
                    for (int x = 0; x < 2; ++x) {
                        SubBlock usb = this.uSubBlocks[x][y];
                        SubBlock vsb = this.vSubBlocks[x][y];
                        int[][] ublock = new int[4][4];
                        int[][] vblock = new int[4][4];
                        for (int j = 0; j < 4; ++j) {
                            for (int i = 0; i < 4; ++i) {
                                ublock[i][j] = leftUSb[y].getMacroBlockPredict(2)[3][j];
                                vblock[i][j] = leftVSb[y].getMacroBlockPredict(2)[3][j];
                            }
                        }
                        usb.setPredict(ublock);
                        vsb.setPredict(vblock);
                    }
                }
                break;
            }
            case 3: {
                MacroBlock ALMb = frame.getMacroBlock(this.x - 1, this.y - 1);
                SubBlock ALUSb = ALMb.getUSubBlock(1, 1);
                int alu = ALUSb.getDest()[3][3];
                SubBlock ALVSb = ALMb.getVSubBlock(1, 1);
                int alv = ALVSb.getDest()[3][3];
                SubBlock[] aboveUSb = new SubBlock[2];
                SubBlock[] leftUSb = new SubBlock[2];
                SubBlock[] aboveVSb = new SubBlock[2];
                SubBlock[] leftVSb = new SubBlock[2];
                for (int x = 0; x < 2; ++x) {
                    aboveUSb[x] = aboveMb.getUSubBlock(x, 1);
                    leftUSb[x] = leftMb.getUSubBlock(1, x);
                    aboveVSb[x] = aboveMb.getVSubBlock(x, 1);
                    leftVSb[x] = leftMb.getVSubBlock(1, x);
                }
                for (int b = 0; b < 2; ++b) {
                    for (int a = 0; a < 4; ++a) {
                        for (int d = 0; d < 2; ++d) {
                            for (int c = 0; c < 4; ++c) {
                                int upred = leftUSb[b].getDest()[3][a] + aboveUSb[d].getDest()[c][3] - alu;
                                upred = Globals.clamp(upred, 255);
                                this.uSubBlocks[d][b].setPixel(c, a, upred);
                                int vpred = leftVSb[b].getDest()[3][a] + aboveVSb[d].getDest()[c][3] - alv;
                                vpred = Globals.clamp(vpred, 255);
                                this.vSubBlocks[d][b].setPixel(c, a, vpred);
                            }
                        }
                    }
                }
                break;
            }
            default: {
                System.out.println("TODO predict_mb_uv: " + this.yMode);
                System.exit(0);
            }
        }
    }

    public void predictY(VP8Frame frame) {
        MacroBlock aboveMb = frame.getMacroBlock(this.x, this.y - 1);
        MacroBlock leftMb = frame.getMacroBlock(this.x - 1, this.y);
        switch (this.yMode) {
            case 0: {
                int x;
                int y;
                boolean up_available = false;
                boolean left_available = false;
                int average = 0;
                int expected_dc = 0;
                if (this.x > 0) {
                    left_available = true;
                }
                if (this.y > 0) {
                    up_available = true;
                }
                if (up_available || left_available) {
                    int i;
                    SubBlock sb;
                    int j;
                    if (up_available) {
                        for (j = 0; j < 4; ++j) {
                            sb = aboveMb.getYSubBlock(j, 3);
                            for (i = 0; i < 4; ++i) {
                                average += sb.getDest()[i][3];
                            }
                        }
                    }
                    if (left_available) {
                        for (j = 0; j < 4; ++j) {
                            sb = leftMb.getYSubBlock(3, j);
                            for (i = 0; i < 4; ++i) {
                                average += sb.getDest()[3][i];
                            }
                        }
                    }
                    int shift = 3;
                    if (up_available) {
                        ++shift;
                    }
                    if (left_available) {
                        ++shift;
                    }
                    expected_dc = average + (1 << shift - 1) >> shift;
                } else {
                    expected_dc = 128;
                }
                int[][] fill = new int[4][4];
                for (y = 0; y < 4; ++y) {
                    for (x = 0; x < 4; ++x) {
                        fill[x][y] = expected_dc;
                    }
                }
                for (y = 0; y < 4; ++y) {
                    for (x = 0; x < 4; ++x) {
                        SubBlock sb = this.ySubBlocks[x][y];
                        sb.setPredict(fill);
                    }
                }
                break;
            }
            case 1: {
                SubBlock[] aboveYSb = new SubBlock[4];
                for (int x = 0; x < 4; ++x) {
                    aboveYSb[x] = aboveMb.getYSubBlock(x, 3);
                }
                for (int y = 0; y < 4; ++y) {
                    for (int x = 0; x < 4; ++x) {
                        SubBlock sb = this.ySubBlocks[x][y];
                        int[][] block = new int[4][4];
                        for (int j = 0; j < 4; ++j) {
                            for (int i = 0; i < 4; ++i) {
                                block[i][j] = aboveYSb[x].getPredict(2, false)[i][3];
                            }
                        }
                        sb.setPredict(block);
                    }
                }
                break;
            }
            case 2: {
                int x;
                SubBlock[] leftYSb = new SubBlock[4];
                for (int x2 = 0; x2 < 4; ++x2) {
                    leftYSb[x2] = leftMb.getYSubBlock(3, x2);
                }
                for (int y = 0; y < 4; ++y) {
                    for (x = 0; x < 4; ++x) {
                        SubBlock sb = this.ySubBlocks[x][y];
                        int[][] block = new int[4][4];
                        for (int j = 0; j < 4; ++j) {
                            for (int i = 0; i < 4; ++i) {
                                block[i][j] = leftYSb[y].getPredict(0, true)[3][j];
                            }
                        }
                        sb.setPredict(block);
                    }
                }
                SubBlock[] leftUSb = new SubBlock[2];
                for (x = 0; x < 2; ++x) {
                    leftUSb[x] = leftMb.getYSubBlock(1, x);
                }
                break;
            }
            case 3: {
                int x;
                MacroBlock ALMb = frame.getMacroBlock(this.x - 1, this.y - 1);
                SubBlock ALSb = ALMb.getYSubBlock(3, 3);
                int al = ALSb.getDest()[3][3];
                SubBlock[] aboveYSb = new SubBlock[4];
                SubBlock[] leftYSb = new SubBlock[4];
                for (x = 0; x < 4; ++x) {
                    aboveYSb[x] = aboveMb.getYSubBlock(x, 3);
                }
                for (x = 0; x < 4; ++x) {
                    leftYSb[x] = leftMb.getYSubBlock(3, x);
                }
                int[][] fill = new int[4][4];
                for (int b = 0; b < 4; ++b) {
                    for (int a = 0; a < 4; ++a) {
                        for (int d = 0; d < 4; ++d) {
                            for (int c = 0; c < 4; ++c) {
                                int pred = leftYSb[b].getDest()[3][a] + aboveYSb[d].getDest()[c][3] - al;
                                this.ySubBlocks[d][b].setPixel(c, a, Globals.clamp(pred, 255));
                            }
                        }
                    }
                }
                break;
            }
            default: {
                System.out.println("TODO predict_mb_y: " + this.yMode);
                System.exit(0);
            }
        }
    }

    public void recon_mb() {
        SubBlock sb;
        int i;
        int j;
        for (j = 0; j < 4; ++j) {
            for (i = 0; i < 4; ++i) {
                sb = this.ySubBlocks[i][j];
                sb.reconstruct();
            }
        }
        for (j = 0; j < 2; ++j) {
            for (i = 0; i < 2; ++i) {
                sb = this.uSubBlocks[i][j];
                sb.reconstruct();
            }
        }
        for (j = 0; j < 2; ++j) {
            for (i = 0; i < 2; ++i) {
                sb = this.vSubBlocks[i][j];
                sb.reconstruct();
            }
        }
    }

    public void setFilterLevel(int value) {
        this.filterLevel = value;
    }

    public void setSegmentId(int value) {
        this.segmentId = value;
    }

    public void setSkipCoeff(int mbSkipCoeff) {
        this.skipCoeff = mbSkipCoeff;
    }

    public void setUVFilterLevel(int value) {
        this.uVFilterLevel = value;
    }

    public void setUvMode(int mode) {
        this.uvMode = mode;
    }

    public void setYMode(int yMode) {
        this.yMode = yMode;
    }

    public String toString() {
        return "x: " + this.x + "y: " + this.y;
    }

    public int getSegmentId() {
        return this.segmentId;
    }
}

