/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.commonmark.internal;

import znaishaded.org.commonmark.internal.util.Parsing;
import znaishaded.org.commonmark.node.Block;
import znaishaded.org.commonmark.node.Heading;
import znaishaded.org.commonmark.parser.InlineParser;
import znaishaded.org.commonmark.parser.block.AbstractBlockParser;
import znaishaded.org.commonmark.parser.block.AbstractBlockParserFactory;
import znaishaded.org.commonmark.parser.block.BlockContinue;
import znaishaded.org.commonmark.parser.block.BlockStart;
import znaishaded.org.commonmark.parser.block.MatchedBlockParser;
import znaishaded.org.commonmark.parser.block.ParserState;

public class HeadingParser
extends AbstractBlockParser {
    private final Heading block = new Heading();
    private final String content;

    public HeadingParser(int level, String content) {
        this.block.setLevel(level);
        this.content = content;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState parserState) {
        return BlockContinue.none();
    }

    @Override
    public void parseInlines(InlineParser inlineParser) {
        inlineParser.parse(this.content, this.block);
    }

    private static HeadingParser getAtxHeading(CharSequence line, int index) {
        int level = Parsing.skip('#', line, index, line.length()) - index;
        if (level == 0 || level > 6) {
            return null;
        }
        int start = index + level;
        if (start >= line.length()) {
            return new HeadingParser(level, "");
        }
        char next = line.charAt(start);
        if (next != ' ' && next != '\t') {
            return null;
        }
        int beforeSpace = Parsing.skipSpaceTabBackwards(line, line.length() - 1, start);
        int beforeHash = Parsing.skipBackwards('#', line, beforeSpace, start);
        int beforeTrailer = Parsing.skipSpaceTabBackwards(line, beforeHash, start);
        if (beforeTrailer != beforeHash) {
            return new HeadingParser(level, line.subSequence(start, beforeTrailer + 1).toString());
        }
        return new HeadingParser(level, line.subSequence(start, beforeSpace + 1).toString());
    }

    private static int getSetextHeadingLevel(CharSequence line, int index) {
        switch (line.charAt(index)) {
            case '=': {
                if (HeadingParser.isSetextHeadingRest(line, index + 1, '=')) {
                    return 1;
                }
            }
            case '-': {
                if (!HeadingParser.isSetextHeadingRest(line, index + 1, '-')) break;
                return 2;
            }
        }
        return 0;
    }

    private static boolean isSetextHeadingRest(CharSequence line, int index, char marker) {
        int afterMarker = Parsing.skip(marker, line, index, line.length());
        int afterSpace = Parsing.skipSpaceTab(line, afterMarker, line.length());
        return afterSpace >= line.length();
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            CharSequence paragraph;
            int nextNonSpace;
            if (state.getIndent() >= Parsing.CODE_BLOCK_INDENT) {
                return BlockStart.none();
            }
            CharSequence line = state.getLine();
            HeadingParser atxHeading = HeadingParser.getAtxHeading(line, nextNonSpace = state.getNextNonSpaceIndex());
            if (atxHeading != null) {
                return BlockStart.of(atxHeading).atIndex(line.length());
            }
            int setextHeadingLevel = HeadingParser.getSetextHeadingLevel(line, nextNonSpace);
            if (setextHeadingLevel > 0 && (paragraph = matchedBlockParser.getParagraphContent()) != null) {
                String content = paragraph.toString();
                return BlockStart.of(new HeadingParser(setextHeadingLevel, content)).atIndex(line.length()).replaceActiveBlockParser();
            }
            return BlockStart.none();
        }
    }
}

